<?php



namespace App\Models\Book;


use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use App\Models\Student\StudentHistory;
use App\Models\User\EmployeeHistory;

class LibraryMember extends ProjectModel
{

    protected $table = 'library_members';
    // Mass assignable fields
    protected $fillable = [
        'type',
        'status',
        'name',
        'email',
        'phone',
        'address',
        'user_id',
        'member_id',
    ];

    /**
     * Optional: Define the relationship to User
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }


    public function getNameAttribute()
    {
        $name = 'Unknown';

        switch ($this->type) {
            case 'student':
                $student = StudentHistory::with(['stClass', 'classGroup', 'student'])
                    ->where('user_id', $this->user_id)
                    ->first();

                if ($student && $student->student) {
                    $name = $student->student->full_name . '<br>';
                    $name .=  $student->stClass ? '( Class: ' . ($student->stClass->class_name ?? '') . ' ) <br>' : '';
                    $name .=  $student->classGroup ?  '( Group: ' . ($student->classGroup->group_name ?? '') . ' )' : '';

                }
                break;
            case 'staff':
            case 'teacher':
                $employee = EmployeeHistory::with('employee')
                    ->where('user_id', $this->user_id)
                    ->first();

                if ($employee) {
                    $name = $employee->full_name . '<br>';
                    $name .=  $employee->designation_name ? '( Designation: ' . ($employee->designation_name ?? '') . ' )' : '';
                }
                break;

            case 'public':
                $name = $this->attributes['name'] ?? '';
                break;
        }

        return $name;
    }
    public function getFullNameAttribute()
    {
        $name = 'Unknown';

        switch ($this->type) {
            case 'student':
                $student = StudentHistory::with(['stClass', 'classGroup', 'student'])
                    ->where('user_id', $this->user_id)
                    ->first();
                if ($student && $student->student) {
                    $name = $student->student->full_name ;

                }
                break;

            case 'staff':
            case 'teacher':
                $employee = EmployeeHistory::with('employee')
                    ->where('user_id', $this->user_id)
                    ->first();

                if ($employee) {
                    $name = $employee->full_name ;
                }
                break;

            case 'public':
                $name = $this->attributes['name'] ?? '';
                break;
        }

        return $name;
    }

    public function getEmailAttribute()
    {
        return $this->getExtraField('email');
    }

    public function getPhoneAttribute()
    {
        if ($this->type === 'public') {
            return $this->attributes['phone'] ;
        }

        return $this->getExtraField('contact_number');
    }

    public function getAddressAttribute()
    {
        return $this->getExtraField('address');
    }

    protected function getExtraField($field)
    {
        switch ($this->type) {
            case 'student':
                $student = StudentHistory::with('student')
                    ->where('user_id', $this->user_id)
                    ->first();
                return $student->student->{$field} ?? '';

            case 'staff':
            case 'teacher':
                $employee = EmployeeHistory::with('employee')
                    ->where('user_id', $this->user_id)
                    ->first();
                return $employee->employee->{$field} ?? '';

            case 'public':
                return $this->attributes[$field] ?? '';

            default:
                return 'N/A';
        }
    }
}
