<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/7/2016
 * Time: 5:12 PM
 */
namespace App\Models\District;

use App\Models\ProjectModel;
use App\Models\Thana\Thana;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dimsav\Translatable\Translatable;
use App\Models\Country\Country;
use App\Models\Division\Division;


class District extends Model
{
    //use SoftDeletes;
    use Translatable;

    public $translationModel = DistrictTranslation::class;
    public $translationForeignKey = 'district_id';

    const DIVISION = 'division_id';
    const NAME = 'district_name';
    const CODE = 'govt_code';
    const STATUS = 'status';
    const THANA_CHECK = 'thana_check';

    public $timestamps = false;

    protected $dates = ['deleted_at'];

    protected $fillable = [
        self::DIVISION,
        self::CODE,
        self::NAME,
        self::STATUS,
        self::THANA_CHECK,
    ];

    public $ownFields = [
        self::DIVISION,
        self::NAME,
        self::CODE,
        self::STATUS,
        self::THANA_CHECK,
    ];

    public $translatedAttributes = [self::NAME];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
 /*   public function country()
    {
        return $this->belongsTo(Country::class);
    }

*/
    public function thanas()
    {
        return $this->hasMany(Thana::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function division()
    {
        return $this->belongsTo(Division::class, 'division_id');
    }
}