<?php

namespace App\Models\Edu\Accounts;

use App\Models\Site\Accounts\AccountsGroup;
use Illuminate\Database\Eloquent\Model;

class AccountsHead extends Model
{
    public $timestamps = true;
    protected $table='accounts_heads';

    const NAME = 'name';
    const HEAD_KEY = 'head_key';
    const ENTRY = 'entry';
    const KEY_NAME = 'key_name';
    const CODE = 'code';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const STATUS = 'status';


    protected $fillable = [
        self::NAME,
        self::HEAD_KEY,
        self::ENTRY,
        self::KEY_NAME,
        self::CODE,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS
    ];

    public $ownFields = [
        self::NAME,
        self::HEAD_KEY,
        self::ENTRY,
        self::KEY_NAME,
        self::CODE,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS
    ];

//    public function classRoom()
//    {
//        return $this->hasMany(ClassRoom::class);
//    }

    public function accountsHead()
    {
        return $this->hasMany(AccountsGroup::class);
    }
    public function AccountsGroup()
    {
        return $this->hasMany(AccountsGroup::class);
    }


}
