<?php

namespace App\Models\Edu\NewSite;

use App\Models\Image\Photo;
use Illuminate\Database\Eloquent\Model;

class Application extends Model
{
    protected $table = 'edu_newsite_applications';
    public $timestamps = true;
    protected $dates = ['deleted_at'];
   // protected $appends = array('head_picture');
    protected $appends = array('site_logo');


    protected $casts = [
        'site_phone' => 'string',
        'status' => 'integer',
        'is_valid' => 'integer',
        'academic_year_ids' => 'string',
    ];

    const FIRST_NAME = 'first_name';
    const LAST_NAME = 'last_name';
    const BOARD = 'board_id';
    const YEAR_IDS = 'academic_year_ids';
    const SITE_GROUP_ID = 'site_group_ids';
    const SITE_NAME = 'site_name';
    const Shift_IDs = 'shift_ids';

    const ACADEMIC_PERIOD_YPE_IDS = 'academic_period_type_ids';
    const Employee_academic_transport_ids = 'employee_academic_transport_ids';
    const Employee_academic_residence_ids = 'employee_academic_residence_ids';
    const Employee_academic_student_quata_ids = 'employee_academic_student_quata_ids';
    const Emp_grade_ids = 'emp_grade_ids';
    const Employee_examination_ids = 'employee_examination_ids';
    const ACADEMIC_FISCAL_YEAR_IDS = 'academic_fiscal_year_ids';
    const ACADEMIC_LEAVE_TYPE_IDS = 'academic_leave_type_ids';
    const ACADEMIC_LEAVE_CATEGORY_IDS = 'academic_leave_cetagory_ids';
    const DESIGNATION_IDS = 'designation_ids';
    const GENDER_IDS = 'gender_ids';
    const ACC_GROUP_IDS = 'academic_group_ids';
    const EIIN = 'eiin';
    const COLLEGE_CODE = 'college_code';
    const NU_CODE = 'nu_code';
    const EXISTED_DOMAIN = 'existed_domain';


    const COUNTRY = 'country_id';
    const DIVISION = 'division_id';
    const DISTRICT = 'district_id';
    const THANA = 'thana_id';
    const SITE_ADDRESS = 'address';
    const SITE_EMAIL = 'site_email';
    const SITE_PHONE = 'site_phone';
    // const SITE_LOGO = 'site_logo';
    const STATUS = 'status';
    const NOTE = 'note';
    const IS_VALID = 'is_valid';


    protected $fillable = [

        self::FIRST_NAME,
        self::LAST_NAME,
        self::ACC_GROUP_IDS,
        self::SITE_NAME,
        self::SITE_ADDRESS,
        self::Shift_IDs,
        self::YEAR_IDS,
        self::ACADEMIC_PERIOD_YPE_IDS,
        self::IS_VALID,
        self::BOARD,
        self::Employee_academic_transport_ids,
        self::Employee_academic_residence_ids,
        self::Employee_academic_student_quata_ids,
        self::Emp_grade_ids,
        self::Employee_examination_ids,
        self::ACADEMIC_FISCAL_YEAR_IDS,
        self::ACADEMIC_LEAVE_TYPE_IDS,
        self::ACADEMIC_LEAVE_CATEGORY_IDS,
        self::DESIGNATION_IDS,
        self::GENDER_IDS,
        self::EIIN,
        self::COLLEGE_CODE,
        self::NU_CODE,
        self::EXISTED_DOMAIN,

        self::COUNTRY,
        self::DIVISION,
        self::DISTRICT,
        self::THANA,
        self::SITE_EMAIL,
        self::SITE_PHONE,
        self::NOTE,
        self::STATUS,
    ];

    public $ownfields = [
        self::FIRST_NAME,
        self::LAST_NAME,
        self::SITE_NAME,
        self::SITE_ADDRESS,
        self::YEAR_IDS,
        self::ACC_GROUP_IDS,
        self::Shift_IDs,
        self::ACADEMIC_PERIOD_YPE_IDS,
        self::IS_VALID,
        self::BOARD,
        self::COUNTRY,
        self::DIVISION,
        self::DISTRICT,
        self::THANA,
        self::EIIN,
        self::COLLEGE_CODE,
        self::NU_CODE,
        self::EXISTED_DOMAIN,

        self::Employee_academic_transport_ids,
        self::Employee_academic_residence_ids,
        self::Employee_academic_student_quata_ids,
        self::Emp_grade_ids,
        self::Employee_examination_ids,
        self::ACADEMIC_FISCAL_YEAR_IDS,
        self::ACADEMIC_LEAVE_TYPE_IDS,
        self::ACADEMIC_LEAVE_CATEGORY_IDS,
        self::DESIGNATION_IDS,
        self::GENDER_IDS,
        self::SITE_EMAIL,
        self::SITE_PHONE,
        self::NOTE,
        self::STATUS,
    ];


    public function getAcademicPeriodTypeIdsAttribute($value)
    {
        return $this->attributes['academic_period_type_ids'] = array_map(function ($v) {
            return (int)trim($v, "'");
        }, explode(",", $value));;
    }
    public function getEmployeeAcademicTransportIdsAttribute($value)
    {
        return $this->attributes['employee_academic_transport_ids'] = array_map(function ($v) {
            return (int)trim($v, "'");
        }, explode(",", $value));;
    }
    public function getEmployeeAcademicResidenceIdsAttribute($value)
    {
        return $this->attributes['employee_academic_residence_ids'] = array_map(function ($v) {
            return (int)trim($v, "'");
        }, explode(",", $value));;
    }
    public function getEmployeeAcademicStudentQuataIdsAttribute($value)
    {
        return $this->attributes['employee_academic_student_quata_ids'] = array_map(function ($v) {
            return (int)trim($v, "'");
        }, explode(",", $value));;
    }
    public function getEmpGradeIdsAttribute($value)
    {
        return $this->attributes['emp_grade_ids'] = array_map(function ($v) {
            return (int)trim($v, "'");
        }, explode(",", $value));;
    }
    public function getEmployeeExaminationIdsAttribute($value)
    {
        return $this->attributes['employee_examination_ids'] = array_map(function ($v) {
            return (int)trim($v, "'");
        }, explode(",", $value));;
    }

    // public function getHeadPictureAttribute()
    // {
    //     return $this->attributes['head_picture'] = ($this->headImage->path ?? '');
    // }

    public function getSiteLogoAttribute()
    {
        return $this->attributes['site_logo'] = ($this->siteLogoImage->path ?? '');
    }

    public function getAcademicGroupIdsAttribute($value)
    {
        return $this->attributes['academic_group_ids'] = array_map(function ($v) {
            return (int)trim($v, "'");
        }, explode(",", $value));
        // return $this->attributes['academic_group_ids'] =$myArray = explode(',', $this->attributes['academic_group_ids']);
    }

    // public function headImage()
    // {
    //     return $this->morphOne(Photo::class, 'imageable');
    // }

    public function siteLogoImage()
    {
        return $this->morphOne(Photo::class, 'imageable');
    }

}
