<?php

namespace App\Models\Edu\SitePayment;

use App\Models\User\GlobalUser;
use Illuminate\Database\Eloquent\Model;

class EduInvoicePayment extends Model
{

    public $timestamps = true;
    protected $table = 'edu_site_invoice_payments';

    protected $casts=[
        'status'=>'integer'
    ];
    protected $dates = ['deleted_at'];

    const AMOUNT = 'paid_amount';
    const DUE = 'due_amount';
    const PAYMENT_TYPE = 'payment_type';
    const PAYMENT_ID = 'payment_id';
    const MONTH_FOR = 'month_for';
    const PIECE = 'piece';
    const PRICE = 'piece_price';
    const DESCRIPTION = 'description';
    const INVOICE_ID = 'invoice_id';
    const DATE = 'payment_date';
    const ONLINE_PAYMENT_CREATE_DATE_TIME = 'online_payment_create_date_time';
    const SITE = 'site_id';
    const USER = 'received_by';
    const PAYMENT_BY = 'payment_by';
    const STATUS = 'status';



    protected $fillable = [
        self::AMOUNT,
        self::DUE,
        self::PIECE,
        self::PRICE,
        self::MONTH_FOR,
        self::PAYMENT_TYPE,
        self::PAYMENT_ID,
        self::DESCRIPTION,
        self::INVOICE_ID,
        self::AMOUNT,
        self::SITE,
        self::DATE,
        self::ONLINE_PAYMENT_CREATE_DATE_TIME,
        self::USER,
        self::PAYMENT_BY,
        self::STATUS
    ];
    public $ownFields = [
        self::AMOUNT,
        self::DUE,
        self::PRICE,
        self::PIECE,
        self::MONTH_FOR,
        self::PAYMENT_TYPE,
        self::PAYMENT_ID,
        self::DESCRIPTION,
        self::INVOICE_ID,
        self::AMOUNT,
        self::SITE,
        self::USER,
        self::PAYMENT_BY,
        self::DATE,
        self::ONLINE_PAYMENT_CREATE_DATE_TIME,
        self::STATUS
    ];

    public function getPaymentMethodAttribute($value){
        return ucwords($value);
    }

    public function getAccountCodeAttribute($value){
        return ucwords($value);
    }
    // SitePayment belongsTo User
    public function getReceivedByAttribute($value)
    {
        if($value){
            $user=GlobalUser::findOrFail($value);
            return  ($user->first_name ?? '').' '.($user->last_name ?? '');

        }else{
            return "";
        }

//        if($user){
//        }else{
//            return "";
//        }


    }


    public function getStatusCodeAttribute($value)
    {
        return ucwords($value);
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function invoice()
    {
        return $this->belongsTo(SiteInvoice::class, 'invoice_id');
    }

}
