<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 6/23/2016
 * Time: 10:14 PM
 */
namespace App\Models\Edu\SitePayment;


use App\Models\ProjectModel;
use App\Models\User\GlobalUser;

class SitePayment extends ProjectModel
{


    public $timestamps = true;
    protected $table = 'edu_site_invoice_payments';

    protected $casts=[
        'status'=>'integer'
    ];
    protected $dates = ['deleted_at'];

    const AMOUNT = 'paid_amount';
    const DUE = 'due_amount';
    const PAYMENT_TYPE = 'payment_type';
    const MONTH_FOR = 'month_for';
    const PIECE = 'piece';
    const PRICE = 'piece_price';
    const DESCRIPTION = 'description';
    const INVOICE_ID = 'invoice_id';
    const DATE = 'payment_date';
    const USER = 'received_by';
    const STATUS = 'status';



    protected $fillable = [
        self::AMOUNT,
        self::DUE,
        self::PIECE,
        self::PRICE,
        self::MONTH_FOR,
        self::PAYMENT_TYPE,
        self::DESCRIPTION,
        self::INVOICE_ID,
        self::AMOUNT,
        self::DATE,
        self::USER,
        self::STATUS
    ];
    public $ownFields = [
        self::AMOUNT,
        self::DUE,
        self::PRICE,
        self::PIECE,
        self::MONTH_FOR,
        self::PAYMENT_TYPE,
        self::DESCRIPTION,
        self::INVOICE_ID,
        self::AMOUNT,
        self::USER,
        self::DATE,
        self::STATUS
    ];

    public function getPaymentMethodAttribute($value){
        return ucwords($value);
    }

    public function getAccountCodeAttribute($value){
        return ucwords($value);
    }
    // SitePayment belongsTo User
    public function getReceivedByAttribute($value)
    {
        $user=GlobalUser::findOrFail($value);
        return  ($user->first_name ?? '').' '.($user->last_name ?? '');
    }
        public function getStatusCodeAttribute($value)
    {
        return ucwords($value);
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */

    public function invoice()
    {
        return $this->belongsTo(SiteInvoice::class, 'invoice_id');
    }


}
