<?php

namespace App\Models\Edu\Transaction;

use Illuminate\Database\Eloquent\Model;

class EduStudentInvoice extends Model
{
    protected $table = 'edu_student_invoices';


    const User_id = 'user_id';
    const Student_history_id = 'student_history_id';
    const Academic_group_id = 'academic_group_id';
    const Edu_student_invoice_declare_id = 'edu_student_invoice_declare_id';
    const Order_id = 'order_id';
    const Payable_amount = 'payable_amount';
    const Paid_amount = 'paid_amount';
    const Online_payment_status = 'online_payment_status';
    const Manual_payment_status = 'manual_payment_status';
    const Payment_company = 'payment_company';
    const Academic_online_payment_method_id = 'academic_online_payment_method_id';
    const Site_id = 'site_id';
    const STATUS = 'status';

    const Payment_from_date = 'payment_from_date';
    const Payment_to_date = 'payment_to_date';
    const Edu_student_panel_close_date = 'edu_student_panel_close_date';


    protected $fillable = [

        self::Site_id,
        self::User_id,
        self::Academic_group_id,
        self::Edu_student_invoice_declare_id,
        self::Order_id,
        self::Student_history_id,
        self::Academic_group_id,
        self::Payable_amount,
        self::Paid_amount,
        self::Online_payment_status,
        self::Manual_payment_status,
        self::Payment_company,
        self::Academic_online_payment_method_id,
        self::STATUS,

        self::Payment_from_date,
        self::Payment_to_date,
        self::Edu_student_panel_close_date,
    ];


    public function eduStudentInvoiceItem()
    {
        return $this->hasMany(EduStudentInvoiceItem::class);
    }
}
