<?php

namespace App\Models\Edu\Transaction;

use App\Models\Academic\AcademicGroup;
use Illuminate\Database\Eloquent\Model;

class EduStudentInvoiceDeclare extends Model
{
    protected $table = 'edu_student_invoice_declares';


    const Site_id = 'site_id';
    const Academic_group_id = 'academic_group_id';
    const Academic_year_id = 'academic_year_id';
    const Payment_from_date = 'payment_from_date';
    const Payment_to_date = 'payment_to_date';
    const Student_panel_colse_date = 'student_panel_colse_date';
    const Payment_amount = 'payment_amount';
    const edu_student_panel_close_status = 'edu_student_panel_close_status';
    const STATUS = 'status';



    protected $fillable = [
        self::Site_id,
        self::Academic_group_id,
        self::Academic_year_id,
        self::Payment_from_date,
        self::Payment_to_date,
        self::Student_panel_colse_date,
        self::Payment_amount,
        self::edu_student_panel_close_status,
        self::STATUS,
    ];

    public function academicGroup()
    {
        return $this->belongsTo(AcademicGroup::class);
    }

    public function eduStudentInvoiceDeclareItem()
    {
        return $this->hasMany(EduStudentInvoiceDeclareItem::class);
    }
}
