<?php

namespace App\Models\Edu\Transaction;

use App\Models\Edu\Item\ItemDetail;
use Illuminate\Database\Eloquent\Model;

class EduStudentInvoiceItem extends Model
{
    protected $table = 'edu_student_invoice_items';


    const Site_student_invoice_id = 'edu_student_invoice_id';
    const Edu_item_detail_id = 'edu_item_detail_id';
    const Payment_amount = 'payment_amount';
    const Site_id = 'site_id';
    const STATUS = 'status';


    protected $fillable = [
        self::Site_id,
        self::Site_student_invoice_id,
        self::Edu_item_detail_id,
        self::Payment_amount,
        self::STATUS,
    ];


    public function itemDetail()
    {
        return $this->belongsTo(ItemDetail::class, 'edu_item_detail_id');
    }
}
