<?php

namespace App\Models\Employee;

use App\Models\EmployeeCategory\EmpCategory;
use App\Models\EmployeePosition\EmpPosition;
use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;

class SiteCategoryPositionSetting extends ProjectModel
{
    protected $table='site_category_position_settings';


    const Emp_category_id = 'emp_category_id';
    const Emp_position_id = 'emp_position_id';
    const Assign_date = 'assign_date';
    const Release_date = 'release_date';
    const Status = 'status';




    public $timestamps = true;


    protected $fillable = [
        self::Emp_category_id,
        self::Emp_position_id,
        self::Assign_date,
        self::Release_date,
        self::Status,
    ];


    protected $ownFields = [
        self::Emp_category_id,
        self::Emp_position_id,
        self::Assign_date,
        self::Release_date,
        self::Status,
    ];


    public function employeeCategory()
    {
        return $this->belongsTo(EmpCategory::class, 'emp_category_id');
    }

    public function employeePosition()
    {
        return $this->belongsTo(EmpPosition::class, 'emp_position_id');
    }
}
