<?php

namespace App\Models\EmployeePosition;

use App\Models\EmployeeCategory\EmpCategory;
use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dimsav\Translatable\Translatable;



class EmpPosition extends Model
{
    //use SoftDeletes;
    use Translatable;

    const NAME = 'name';
    const EMP_CATEGORY_ID = 'emp_category_id';
    const STATUS = 'status';

    public $timestamps = false;


    protected $dates = ['deleted_at'];

    protected $fillable = [
            self::NAME,
            self::STATUS,
            self::EMP_CATEGORY_ID
         ];
    public $translatedAttributes = [self::NAME];


    public function empcategory()
    {
        return $this->belongsTo(EmpCategory::class,'emp_category_id');
    }

}

