<?php

namespace App\Models\Holydays;

use App\Models\Edu\Holiday\HolidayForSite;
use App\Models\ProjectModel;
use App\Models\Status\Status;
use Illuminate\Database\Eloquent\Model;
use App\Models\Holydays\HolyDayType;

class Holyday extends Model
{

    protected $table='holydays';

    const HOLIDAY_NAME = 'holiday_name';
    const HEAD_KEY = 'head_key';
    const STATUS = 'status';




    public $timestamps = false;

    protected $fillable = [
        self::HOLIDAY_NAME,
        self::HEAD_KEY,
        self::STATUS,

    ];

    public $ownFields = [
        self::HOLIDAY_NAME,
        self::HEAD_KEY,
        self::STATUS,

    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function holyDayType()
    {
        return $this->belongsTo(HolyDayType::class);
    }

    public function holidayForSite()
    {
        return $this->hasMany(HolidayForSite::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function status()
    {
        return $this->belongsTo(Status::class);
    }



}
