<?php

/**
 * Created by PhpStorm.
 * User: raja
 * Date: 5/15/16
 * Time: 4:21 PM
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Auth;

abstract class ProjectModel extends Model
{
    const SITE_ID = 'site_id';


    /**
     * ProjectModel constructor.
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        $this->fillable[] = self::SITE_ID;
        $this->{self::SITE_ID} = (int)session()->get('SITE_ID');
        parent::__construct($attributes);
    }


    public function newQuery()
    {
        $site_id = isset(Auth::user()->site_id) ? Auth::user()->site_id : (int)session()->get('SITE_ID');
        $builder = $this->newQueryWithoutScopes();
        $tableName = $builder->getModel()->getTable();
        $final = $builder->where($tableName . '.site_id', $site_id);

        return $final; //$this->applyGlobalScopes($final);
    }



    //Some demo complex query for future help
    /*
Debug eloquent as sql:
$mydata = User::where('id',1);
return dd($mydata->toSql(),$mydata->getBindings());


\DB::listen(function($sql) {
    dump($sql);
});z
*/


    /*
    $allCats = Category::with('latestPost')->get();

    // using strict operator === ...
    $filteredCats = $allCats->where('latestPost.status', 'published');

    // ... or using loose operator ==
    $filteredCats = $allCats->whereLoose('latestPost.status', 'published');*/


    /*
    Category::whereHas('posts', function ($posts) {

        $posts->where('status', 'published')
            ->where('id', function ($sub) {
                $sub->from('posts as sub')
                    ->selectRaw('max(id)')
                    ->whereRaw('sub.category_id = posts.category_id')
        });
    });
    })->with('latestPost')->get()*/



    /*  public function setSiteIdAttribute()
      {
          $this->attributes[self::SITE_ID] = Session::get(SITE_ID);
      }*/

    /*protected static function boot()
     {
         parent::boot();
         static::addGlobalScope(new ProjectScope());
     }*/

    /*
    public function approvedUsers() {
        return $this->hasMany('App\User')->where('approved', 1)->orderBy('email');
    }*/
}
