<?php

namespace App\Models\Site\Academic;

use App\Models\Academic\AcademicPeriodType;
use App\Models\AcademicYear\AcademicYear;
use App\Models\SiteGlobalModel;
use App\Traits\Site\Log\AuditLogTrait;

class SitePeriodTypeDuration extends SiteGlobalModel
{
   // use AuditLogTrait;


    public $timestamps = true;
    protected $table = 'site_period_type_durations';


    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_PERIOD_TYPE_ID = 'academic_period_type_id';
    const START_DATE = 'start_date';
    const END_DATE = 'end_date';

    protected $fillable = [
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_PERIOD_TYPE_ID,
        self::START_DATE,
        self::END_DATE,
    ];


    /*protected static function boot()
    {
        parent::boot();
        static::saving(function ($model) {
            \Log::info($model);
            //$model->slug = str_slug($model->title);
        });
    }*/



    public function setStartDateAttribute($value)
    {
        return $this->attributes['start_date'] = date('Y-m-d', strtotime($value));
    }

    public function setEndDateAttribute($value)
    {
        return $this->attributes['end_date'] = date('Y-m-d', strtotime($value));
    }

    public function AcademicPeriodType()
    {
        return $this->belongsTo(AcademicPeriodType::class, 'academic_period_type_id');
    }

}
