<?php

namespace App\Models\Site\Accounts;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteAccountsVoucherChequeRegisterRecords extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_accounts_voucher_cheque_register_records';

    const SITE_ACCOUNTS_VOUCHER_DETAIL_ID = 'site_accounts_voucher_detail_id';
    const SITE_ACCOUNTS_CHEQUE_REGISTER_ID = 'site_accounts_cheque_register_id';
    const SITE_ACCOUNTS_BANK_ACCOUNT_DETAIL_ID = 'site_accounts_bank_account_detail_id';
    const SITE_ACCOUNT_ID = 'site_account_id';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';


    protected $fillable = [
        self::SITE_ACCOUNTS_VOUCHER_DETAIL_ID,
        self::SITE_ACCOUNTS_CHEQUE_REGISTER_ID,
        self::SITE_ACCOUNTS_BANK_ACCOUNT_DETAIL_ID,
        self::SITE_ACCOUNT_ID,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,
    ];

    public $ownFields = [
        self::SITE_ACCOUNTS_VOUCHER_DETAIL_ID,
        self::SITE_ACCOUNTS_CHEQUE_REGISTER_ID,
        self::SITE_ACCOUNTS_BANK_ACCOUNT_DETAIL_ID,
        self::SITE_ACCOUNT_ID,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,

    ];

    public function accounts()
    {
        return $this->belongsTo(Accounts::class);
    }

    public function chequeRegister()
    {
        return $this->belongsTo(ChequeRegister::class, 'site_accounts_cheque_register_id');
    }
}
