<?php

namespace App\Models\Site\Assessment;

use Illuminate\Database\Eloquent\Model;
use App\Models\ProjectModel;

class SiteIndividualCombineSubjectAssessmentResultStore extends ProjectModel
{
    protected $table = 'site_individual_combine_subject_assessment_result_stores';

    const Student_history_id = 'student_history_id';
    const Assessment_result_details_id = 'assessment_result_details_id';
    const site_subject_group_condition_setting_id = 'site_subject_group_condition_setting_id';
    const Optional_academic_subject_status = 'optional_academic_subject_status';
    const Subject_base_pass_fail_status = 'subject_base_pass_fail_status';
    const Subject_count = 'subject_count';
    const Subject_detail = 'subject_detail';
    const Subject_total_mark = 'subject_total_mark';
    const Total_type_no_count = 'total_type_no_count';
    const Result_type_no_count = 'result_type_no_count';
    const Assessment_attendance_status = 'assessment_attendance_status';
    const STATUS = 'status';
    const Site_id = 'site_id';

    
    protected $fillable = [
        self::Student_history_id,
        self::Assessment_result_details_id,
        self::site_subject_group_condition_setting_id,
        self::Optional_academic_subject_status,
        self::Subject_base_pass_fail_status,
        self::Subject_count,
        self::Subject_detail,
        self::Total_type_no_count,
        self::Result_type_no_count,
        self::Subject_total_mark,
        self::Assessment_attendance_status,
        self::STATUS,
        self::Site_id,
    ];

    public $ownFields = [
        self::Student_history_id,
        self::Assessment_result_details_id,
        self::site_subject_group_condition_setting_id,
        self::Optional_academic_subject_status,
        self::Subject_base_pass_fail_status,
        self::Subject_count,
        self::Total_type_no_count,
        self::Result_type_no_count,
        self::Subject_detail,
        self::Subject_total_mark,
        self::Assessment_attendance_status,
        self::STATUS,
        self::Site_id,
    ];

    public function getSubjectDetailAttribute($values)
    {
        return $this->attributes['subject_detail'] = json_decode($values);

    }

}
