<?php

namespace App\Models\Site\AssessmentResult;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;
use App\Models\Academic\AcademicAssessmentPrimaryResultType;
use App\Models\Assessment\Assessment;

class SiteAssessmentResultPrimarySetting extends SiteGlobalModel
{
    public $timestamps = false;
    protected $table='site_assessment_result_primary_settings';
    protected $appends = array('assessment_name');

    const Academic_year_id = 'academic_year_id';
    const Academic_version_id = 'academic_version_id';
    const Academic_shift_id = 'academic_shift_id';
    const Academic_department_id = 'academic_department_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_class_group_id = 'academic_class_group_id';
    const Academic_session_id = 'academic_session_id';
    const Academic_assessment_result_primary_type_id = 'academic_assessment_result_primary_type_id';

    const Assessment_id = 'assessment_id';
    const Show_position = 'show_position';

    const Status = 'status';
    const Site_id = 'site_id';
    const Academic_group_id = 'academic_group_id';



    protected $fillable = [
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
        self::Academic_session_id,
        self::Assessment_id,
        self::Academic_assessment_result_primary_type_id,
        self::Show_position,
        self::Status,
        self::Academic_group_id,
    ];

    public $ownFields = [
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
        self::Academic_session_id,
        self::Assessment_id,
        self::Academic_assessment_result_primary_type_id,
        self::Show_position,
        self::Status,
        self::Academic_group_id,
    ];

    public function getAssessmentNameAttribute()
    {
        return $this->attributes['assessment_name'] = $this->assessment->assessment_name ?? '';
    }

    public function academicAssessmentPrimaryResultType()
    {
        return $this->belongsTo(AcademicAssessmentPrimaryResultType::class,'academic_assessment_result_primary_type_id');
    }
    public function assessment()
    {
        return $this->belongsTo(Assessment::class,'assessment_id');
    }

}
