<?php

namespace App\Models\Site\AssessmentResult;

use App\Models\Academic\AcademicAssessmentCombineResultType;
use App\Models\Assessment\AssessmentType;
use App\Models\ProjectModel;
use App\Models\Site\Student\GlobalStudentHistory;
use Illuminate\Database\Eloquent\Model;

class SiteStudentAssessmentCombineFinalResultDetail extends ProjectModel
{
    public $timestamps = true;
    protected $table='site_student_assessment_combine_final_result_details';
    protected $appends = array('assessment_primary_result_name');


    const STUDENT_HISTORY_ID = 'student_history_id';
    const Academic_assessment_result_primary_type_id = 'academic_assessment_result_combine_type_id';
    const Assessment_type_id = 'assessment_type_id';
    const Result_details = 'result_details';
    const Expertise_wise_result_details = 'expertise_wise_result_details';

    const Result_type_key = 'result_type_key';

    const Result_employee_publish_status = 'result_employee_publish_status';
    const Result_student_publish_status = 'result_student_publish_status';
    const Result_public_publish_status = 'result_public_publish_status';
    
    const STATUS = 'status';
    const Site_id = 'site_id';


    protected $fillable = [
        self::STUDENT_HISTORY_ID,
        self::Academic_assessment_result_primary_type_id,
        self::Assessment_type_id,
        self::Result_details,
        self::Expertise_wise_result_details,
        self::Result_type_key,
        self::Result_employee_publish_status,
        self::Result_student_publish_status,
        self::Result_public_publish_status,
        self::STATUS,
        self::Site_id,
    ];

   

    public function getAssessmentPrimaryResultNameAttribute()
    {
        return $this->attributes['assessment_combine_result_name'] = $this->academicAssessmentCombineResultType->name ?? '';
    }
   

    public function studentHistory()
    {
        return $this->belongsTo(GlobalStudentHistory::class);
    }

    public function academicAssessmentCombineResultType()
    {
        return $this->belongsTo(AcademicAssessmentCombineResultType::class,'academic_assessment_result_combine_type_id');
    }


    public function getResultDetailsAttribute($values)
    {
        return $this->attributes['result_details'] = json_decode($values, true);
    }

    public function getExpertiseWiseResultDetailsAttribute($values)
    {
        return $this->attributes['expertise_wise_result_details'] = json_decode($values, true);
    }

    public function assessmentType()
    {
        return $this->belongsTo(AssessmentType::class,'assessment_type_id');
    }
}
