<?php

namespace App\Models\Site\AssessmentResult;

use App\Models\Assessment\Assessment;
use App\Models\Assessment\AssessmentType;
use App\Models\ProjectModel;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\Assessment\SiteIndividualCombineSubjectAssessmentResultStore;
use Illuminate\Database\Eloquent\Model;

class SiteStudentAssessmentResultDetail extends ProjectModel
{
    public $timestamps = true;
    protected $table='site_student_assessment_result_details';
    protected $appends = array('assessment_name');


    const STUDENT_HISTORY_ID = 'student_history_id';
    const Assessment_declare_id = 'assessment_declare_id';
    const Assessment_id = 'assessment_id';
    const Assessment_type_id = 'assessment_type_id';
    const FAIL_SUBJECT_COUNT = 'fail_subject_count';
    // const RESULT_DETAIL = 'result_detail';
    const Site_individual_combine_subject_assessment_result_stores_ids = 'site_individual_combine_subject_assessment_result_stores_ids';
    const Result_details = 'result_details';
    const Type_no_wise_result_details = 'type_no_wise_result_details';
    const Result_type_key = 'result_type_key';
    const Student_rank = 'student_rank';
    const Assessment_attendance_status = 'assessment_attendance_status';

    const Result_employee_publish_status = 'result_employee_publish_status';
    const Result_student_publish_status = 'result_student_publish_status';
    const Result_public_publish_status = 'result_public_publish_status';
    
    const STATUS = 'status';
    const SITE_ID = 'SITE_ID';

 

    protected $fillable = [
        self::STUDENT_HISTORY_ID,
        self::Assessment_declare_id,
        self::FAIL_SUBJECT_COUNT,
        self::Site_individual_combine_subject_assessment_result_stores_ids,
        self::Result_details,
        self::Type_no_wise_result_details,
        self::Result_type_key,
        self::Student_rank,
        self::Assessment_attendance_status,
        self::Result_employee_publish_status,
        self::Result_student_publish_status,
        self::Result_public_publish_status,
        self::STATUS,
        self::SITE_ID,

    ];

  

    public function getAssessmentNameAttribute()
    {
        return $this->attributes['assessment_name'] = $this->assessment->assessment_name ?? '';
    }
    public function assessment()
    {
        return $this->belongsTo(Assessment::class);

    }


    public function studentHistory()
    {
        return $this->belongsTo(GlobalStudentHistory::class);
    }

 
    public function subjectList()
    {
        return $this->hasMany(SiteIndividualCombineSubjectAssessmentResultStore::class,'assessment_result_details_id');
    }

    // public function getSiteIndividualCombineSubjectAssessmentResultStoresIdsAttribute($value)
    // {
    //     $arr = $value ? array_map('intval', explode(',', $value)) : [];
    //     $array = SiteIndividualCombineSubjectAssessmentResultStore::whereIn('id', $arr)
    //         ->where('status', true)
    //        // ->orderBy('subject_position')
    //         ->get();
    //     return $array;

    // }

    public function getResultDetailsAttribute($values)
    {
        return $this->attributes['result_details'] = json_decode($values,true);

    }

    public function getTypeNoWiseResultdetailsAttribute($values)
    {
        return $this->attributes['type_no_wise_result_details'] = json_decode($values,true);

    }

    // public function getSubjectDetailAttribute($values)
    // {
    //     return $this->attributes['subject_detail'] = json_decode($values);

    // }



    public function assessmentType()
    {
        return $this->belongsTo(AssessmentType::class,'assessment_type_id');
    }

}




