<?php

namespace App\Models\Site\Employee;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicGroup;
use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;

class SiteEmployeeOtherPermission extends ProjectModel
{

    public $timestamps = true;
    protected $table = 'site_employee_other_permissions';

    const USER_ID = 'user_id';
    const Academic_group_id = 'academic_group_id';
    const Fee_permission_class_ids = 'fee_permission_class_ids';
    const Site_id = 'site_id';
    const STATUS = 'status';

    protected $fillable = [
        self::USER_ID,
        self::Academic_group_id,
        self::Fee_permission_class_ids,
        self::Site_id,
        self::STATUS
    ];

    public function academicGroup()
    {
        return $this->belongsTo(AcademicGroup::class,'academic_group_id');
    }
    public function employee()
    {
        return $this->belongsTo(Employee::class,'user_id');
    }
 
    public function getFeePermissionClassIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicClass::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }

}
