<?php

namespace App\Models\Site\EmployeeLeave;

use App\Models\Academic\AcademicFiscalYear;
use App\Models\Academic\AcademicLeaveType;
use App\Models\AcademicYear\AcademicYear;
use App\Models\SiteGlobalModel;
use App\Models\User\EmployeeHistory;
use Illuminate\Database\Eloquent\Model;

class SiteEmployeeLeaveGenerate extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_employee_leave_generates';

    const SITE_LEAVE_POLICY_ID = 'site_leave_policy_id';
    const EMPLOYEE_PREVIOUS_HISTORY_ID = 'employee_previous_history_id';
    const EMPLOYEE_HISTORY_ID = 'employee_history_id';
    const ACADEMIC_FISCAL_YEAR_ID = 'academic_fiscal_year_id';
    const Academic_year_id = 'academic_year_id';
    const PREVIOUS_LEAVE_DAYS_REMAINING = 'previous_leave_days_remaining';
    const LEAVE_DAYS = 'leave_days';
    const STATUS = 'status';


    protected $fillable = [
        self::SITE_LEAVE_POLICY_ID,
        self::EMPLOYEE_PREVIOUS_HISTORY_ID,
        self::EMPLOYEE_HISTORY_ID,
        self::ACADEMIC_FISCAL_YEAR_ID,
        self::Academic_year_id,
        self::PREVIOUS_LEAVE_DAYS_REMAINING,
        self::LEAVE_DAYS,
        self::STATUS
    ];

    public $ownFields = [
        self::SITE_LEAVE_POLICY_ID,
        self::EMPLOYEE_PREVIOUS_HISTORY_ID,
        self::EMPLOYEE_HISTORY_ID,
        self::ACADEMIC_FISCAL_YEAR_ID,
        self::Academic_year_id,
        self::PREVIOUS_LEAVE_DAYS_REMAINING,
        self::LEAVE_DAYS,
        self::STATUS
    ];

    public function siteLeavePolicy()
    {
        return $this->belongsTo(SiteLeavePolicy::class);
    }

    public function employeeHistory()
    {
        return $this->belongsTo(EmployeeHistory::class);
    }

    public function academicFiscalYear()
    {
        return $this->belongsTo(AcademicFiscalYear::class);
    }

    public function academicYear()
    {
        return $this->belongsTo(AcademicYear::class);
    }

    public function siteEmployeeLeaveHistory()
    {
        return $this->hasMany(SiteEmployeeLeaveHistory::class);
    }


}
