<?php

namespace App\Models\Site\Exam;

use App\Models\Academic\AcademicExamType;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteSubjectExaminationExamTypeMark extends SiteGlobalModel
{
    protected $table='site_subject_examination_exam_type_marks';
    protected $appends = array('start_date','end_date', 'start_time', 'end_time', 'duration');

    const Site_subject_examination_mark_id = 'site_subject_examination_mark_id';
    const Academic_exam_type_id = 'academic_exam_type_id';
    const Marks = 'marks';
    const Pass_marks = 'pass_marks';
    const Countable_marks_status = 'countable_marks_status';
    const Countable_marks = 'countable_marks';
    const Countable_persent_of_obtain_marks = 'countable_persent_of_obtain_marks';
    const Academic_group_id = 'academic_group_id';
    const Academic_exam_type_ids = 'academic_exam_type_ids';
    const Status = 'status';



    protected $fillable = [
        self::Site_subject_examination_mark_id,
        self::Academic_exam_type_id,
        self::Marks,
        self::Pass_marks,
        self::Countable_marks_status,
        self::Countable_marks,
        self::Countable_persent_of_obtain_marks,
        self::Academic_exam_type_ids,
        self::Academic_group_id,
        self::Status,
    ];

    protected $ownFields = [
        self::Site_subject_examination_mark_id,
        self::Academic_exam_type_id,
        self::Marks,
        self::Academic_exam_type_ids,
        self::Pass_marks,
        self::Countable_marks_status,
        self::Countable_marks,
        self::Countable_persent_of_obtain_marks,
        self::Academic_group_id,
        self::Status,
    ];


    public function academicExamType()
    {
        return $this->belongsTo(AcademicExamType::class);
    }
    // public function SiteSubjectExaminationMark()
    // {
    //     return $this->belongsTo(SiteSubjectExaminationMark::class);
    // }
    

    public function getStartDateAttribute()
    {
        return  $this->attributes['start_date']= null;

    }
    public function getEndDateAttribute()
    {
        return  $this->attributes['end_date']=  null;

    }
    public function getStartTimeAttribute()
    {
        return  $this->attributes['start_time']=  null;

    }
    public function getEndTimeAttribute()
    {
        return  $this->attributes['end_time']= null;

    }
    public function getDurationAttribute()
    {
        return  $this->attributes['duration']=  null;

    }
}
