<?php

namespace App\Models\Site\Fee;

use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicFeeType;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteStudentFeeGenerate extends Model
{
    public $timestamps = true;
    protected $table='site_student_fee_generates';

    const Student_history_id = 'student_history_id';
    const Site_student_fee_fine_allocation_id = 'site_student_fee_fine_allocation_id';
    const Academic_fee_head_id = 'academic_fee_head_id';
    const Academic_fee_sub_head_id = 'academic_fee_sub_head_id';
    const Fee_head_type_id = 'fee_head_type_id';
    const AMOUNT = 'amount';
    const SITE_ID = 'site_id';
    const Site_group_id = 'site_group_id';
    const STATUS = 'status';
    const Site_student_fee_demand_slip_detail_id = 'site_student_fee_demand_slip_detail_id';
    const DEMAND_SLIP_CREATE_STATUS = 'demand_slip_create_status';


    protected $fillable = [
        self::Student_history_id,
        self::Site_student_fee_fine_allocation_id,
        self::Academic_fee_head_id,
        self::Academic_fee_sub_head_id,
        self::Fee_head_type_id,
        self::AMOUNT,
        self::SITE_ID,
        self::Site_group_id,
        self::STATUS,
        self::Site_student_fee_demand_slip_detail_id,
        self::DEMAND_SLIP_CREATE_STATUS
    ];

    public $ownFields = [
        self::Student_history_id,
        self::Site_student_fee_fine_allocation_id,
        self::Academic_fee_head_id,
        self::Academic_fee_sub_head_id,
        self::Fee_head_type_id,
        self::AMOUNT,
        self::SITE_ID,
        self::Site_group_id,
        self::STATUS,
        self::Site_student_fee_demand_slip_detail_id,
        self::Site_student_fee_demand_slip_detail_id,
    ];




    public function academicFeeType()
    {
        return $this->belongsTo(AcademicFeeType::class,'fee_head_type_id');
    }

    public function academicFeeHead()
    {
        return $this->belongsTo(AcademicFeeHead::class,'academic_fee_head_id');
    }
    public function academicFeeSubHead()
    {
        return $this->belongsTo(AcademicFeeSubHead::class,'academic_fee_sub_head_id');
    }

    public function siteStudentFeeFineAllocation()
    {
        return $this->belongsTo(GlobalSiteStudentFeeFineAllocation::class);
    }


    public function globalSiteStudentFeeDemandSlipDetails()
    {
        return $this->belongsTo(GlobalSiteStudentFeeDemandSlipDetails::class, 'site_student_fee_demand_slip_detail_id', 'id');
    }


}
