<?php

namespace App\Models\Site\Fee;

use Illuminate\Database\Eloquent\Model;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Payment\GlobalSitePaymentGateway;

class GlobalSiteStudentFeePaymentHistory extends Model
{
    public $timestamps = true;
    protected $table='site_student_fee_payment_histories';

    const Academic_group_id = 'academic_group_id';
    const Student_history_id = 'student_history_id';
    const Site_student_fee_demand_slip_details_id = 'site_student_fee_demand_slip_details_id';
    const Payment_date = 'payment_date';
    const Payment_time = 'payment_time';
    const Paid_amount = 'paid_amount';
    const Due_amount = 'due_amount';
    const Tr_amount = 'tr_amount';
    const Iid = 'iid';
    const Bank_name = 'bank_name';
    const Transaction_id = 'transaction_id';
    const Voucher_no = 'voucher_no';
    const Created_by = 'created_by';
    const Site_id = 'site_id';
    const Site_group_id = 'site_group_id';
    const Random_number = 'random_number';
    const Online_payment_status = 'online_payment_status';
    const STATUS = 'status';

    const Edu_service_charge_percentage_status = 'edu_service_charge_percentage_status';
    const Edu_service_charge_amount = 'edu_service_charge_amount';
    const Bank_service_charge_percentage = 'bank_service_charge_percentage';
    const Bank_service_charge_amount = 'bank_service_charge_amount';
    const Site_payment_gateway_id = 'site_payment_gateway_id';
    const Sonali_pay_mode = 'sonali_pay_mode';
    const Sonali_pay_api_response_details = 'sonali_pay_api_response_details';
    const Account_setting_info = 'account_setting_info';
    const Credit_info = 'credit_info';

    protected $fillable = [
        self::Academic_group_id,
        self::Student_history_id,
        self::Site_student_fee_demand_slip_details_id,
        self::Payment_date,
        self::Payment_time,
        self::Paid_amount,
        self::Due_amount,
        self::Tr_amount,
        self::Iid,
        self::Voucher_no,
        self::Bank_name,
        self::Transaction_id,
        self::Created_by,
        self::Site_id,
        self::Site_group_id,
        self::Random_number,
        self::Online_payment_status,

        self::Edu_service_charge_percentage_status,
        self::Edu_service_charge_amount,
        self::Bank_service_charge_percentage,
        self::Bank_service_charge_amount,
        self::Site_payment_gateway_id,
        self::Sonali_pay_mode,
        self::Sonali_pay_api_response_details,
        self::Account_setting_info,
        self::Credit_info,

        self::STATUS
    ];

    public $ownFields = [
        self::Academic_group_id,
        self::Student_history_id,
        self::Site_student_fee_demand_slip_details_id,
        self::Payment_date,
        self::Payment_time,
        self::Paid_amount,
        self::Due_amount,
        self::Tr_amount,
        self::Iid,
        self::Voucher_no,
        self::Bank_name,
        self::Transaction_id,
        self::Created_by,
        self::Site_id,
        self::Site_group_id,
        self::Random_number,
        self::Online_payment_status,
        
        self::Edu_service_charge_percentage_status,
        self::Edu_service_charge_amount,
        self::Bank_service_charge_percentage,
        self::Bank_service_charge_amount,
        self::Site_payment_gateway_id,
        self::Sonali_pay_mode,
        self::Sonali_pay_api_response_details,
        self::Account_setting_info,
        self::Credit_info,

        self::STATUS
    ];

   public function globalSiteStudentFeeDemandSlipDetails()
   {
       return $this->belongsTo(GlobalSiteStudentFeeDemandSlipDetails::class);
   }

    public function globalStudentHistory()
    {
        return $this->belongsTo(GlobalStudentHistory::class,'student_history_id');
    }
    public function studentHistory()
    {
        return $this->belongsTo(GlobalStudentHistory::class,'student_history_id');
    }

    public function paymentGateway()
    {
        return $this->belongsTo(GlobalSitePaymentGateway::class,'site_payment_gateway_id');
    }

}
