<?php

namespace App\Models\Site\Fee;

use App\Models\ProjectModel;
use App\Models\Site\Accounts\SiteAccountsVoucherDetailsStudentPaymentHistoryRecord;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Site\Payment\SitePaymentGateway;
use App\Models\SiteGlobalModel;
use App\Models\Student\StudentHistory;
use App\User;
use Illuminate\Database\Eloquent\Model;

class SiteStudentFeeDemandSlipDetails extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_student_fee_demand_slip_details';
    protected $appends = array('slip_no');


    const Id = 'id';
    const Student_history_id = 'student_history_id';
    const Total_amount = 'total_amount';
    const Demand_slip_create_status = 'demand_slip_create_status';
    const Site_id = 'site_id';
    const Academic_group_id = 'academic_group_id';
    const Previous_due = 'previous_due';
    const Site_student_fee_generate_ids = 'site_student_fee_generate_ids';
    const Site_student_fee_waiver_offer_history_ids = 'site_student_fee_waiver_offer_history_ids';
    const Payment_duration = 'payment_duration';
    const Site_group_id = 'site_group_id';
    const Fee_amount = 'fee_amount';
    const Waiver_amount = 'waiver_amount';
    const Special_waiver_amount = 'special_waiver_amount';
    const Total_waiver_amount = 'total_waiver_amount';

    const Offer_amount = 'offer_amount';
    const Created_by = 'created_by';
    const Due_fine = 'due_fine';
    const Last_payment_date = 'last_payment_date';
    const Created_date = 'created_date';
    const Payment_fine_status = 'payment_fine_status';
    const Delay_fine = 'delay_fine';
    const Payment_from_date = 'payment_from_date';
    const Payment_to_date = 'payment_to_date';
    const Previous_site_student_fee_demand_slip_detail_id = 'previous_site_student_fee_demand_slip_detail_id';
    const Previous_class_due_payment_history_id = 'previous_class_due_payment_history_id';
    const Due_transfer_to_promoted_student_history_id = 'due_transfer_to_promoted_student_history_id';
    const Previous_academic_class_due_status = 'previous_academic_class_due_status';
    const Status = 'status';
    const ACCOUNTS_RECEIVED_STATUS = 'accounts_received_status';
    const ORDER_ID = 'order_id';
    const SITE_PAYMENT_GATEWAY_ID = 'site_payment_gateway_id';
    const Transaction_token = 'transaction_token';
    const Credit_info = 'credit_info';
    const Credit_condition = 'credit_condition';


    protected $fillable = [

        self:: Id,
        self:: Student_history_id,
        self:: Total_amount,
        self:: Demand_slip_create_status,
        self:: Site_id,
        self:: Academic_group_id,
        self:: Previous_due,
        self:: Site_student_fee_generate_ids,
        self:: Site_student_fee_waiver_offer_history_ids,
        self:: Payment_duration,
        self:: Site_group_id,
        self:: Fee_amount,
        self:: Waiver_amount,
        self:: Special_waiver_amount, 
        self:: Total_waiver_amount, 
        self:: Offer_amount,
        self:: Created_by,
        self:: Due_fine,
        self:: Last_payment_date,
        self:: Created_date,
        self:: Payment_fine_status,
        self:: Delay_fine,
        self:: Payment_from_date,
        self:: Payment_to_date,
        self:: Previous_site_student_fee_demand_slip_detail_id,
        self:: Previous_class_due_payment_history_id,
        self:: Due_transfer_to_promoted_student_history_id,
        self:: Previous_academic_class_due_status,
        self:: Status,
        self:: ACCOUNTS_RECEIVED_STATUS,
        self:: ORDER_ID,
        self:: SITE_PAYMENT_GATEWAY_ID,
        self:: Transaction_token,
        self:: Credit_info,
        self:: Credit_condition,

    ];

    public $ownFields = [
        self:: Id,
        self:: Student_history_id,
        self:: Total_amount,
        self:: Demand_slip_create_status,
        self:: Site_id,
        self:: Academic_group_id,
        self:: Previous_due,
        self:: Site_student_fee_generate_ids,
        self:: Site_student_fee_waiver_offer_history_ids,
        self:: Payment_duration,
        self:: Site_group_id,
        self:: Fee_amount,
        self:: Waiver_amount,
        self:: Special_waiver_amount,
        self:: Total_waiver_amount,
        self:: Offer_amount,
        self:: Created_by,
        self:: Due_fine,
        self:: Last_payment_date,
        self:: Created_date,
        self:: Payment_fine_status,
        self:: Delay_fine,
        self:: Payment_from_date,
        self:: Payment_to_date,
        self:: Previous_site_student_fee_demand_slip_detail_id,
        self:: Previous_class_due_payment_history_id,
        self:: Due_transfer_to_promoted_student_history_id,
        self:: Previous_academic_class_due_status,
        self:: Previous_academic_class_due_status,
        self:: Status,
        self:: ACCOUNTS_RECEIVED_STATUS,
        self:: ORDER_ID,
        self:: SITE_PAYMENT_GATEWAY_ID,
        self:: Transaction_token,
        self:: Credit_info,
        self:: Credit_condition,
    ];

    //mutator
    public function getSlipNoAttribute($value)
    {

        return  $this->attributes['slip_no']= $this->attributes['id']+100000;

    }

    public function siteStudentFeePaymentHistory()
    {
        return $this->hasMany(SiteStudentFeePaymentHistory::class);
    }

    public function siteStudentFeeFine()
    {
        return $this->hasMany(SiteStudentFeeFine::class,'site_student_fee_demand_slip_details_id');
    }

    public function siteAccountsVoucherDetailsStudentPaymentHistoryRecord()
    {
        return $this->hasOne(SiteAccountsVoucherDetailsStudentPaymentHistoryRecord::class,'site_student_fee_demand_slip_detail_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class,'created_by','id');
    }

    public function paymentGateway()
    {
        return $this->belongsTo(SitePaymentGateway::class,'site_payment_gateway_id');
    }

    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class,'student_history_id');

    }

}
