<?php

namespace App\Models\Site\Fee;

use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicFeeType;
use App\Models\ProjectModel;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteStudentFeeGenerate extends ProjectModel
{
    public $timestamps = true;
    protected $table='site_student_fee_generates';

    const Student_history_id = 'student_history_id';
    const Site_student_fee_fine_allocation_id = 'site_student_fee_fine_allocation_id';
    const Academic_section_id = 'academic_section_id';
    const Fee_head_type_id = 'fee_head_type_id';
    const Academic_fee_head_id = 'academic_fee_head_id';
    const Academic_fee_sub_head_id = 'academic_fee_sub_head_id';
    const AMOUNT = 'amount';
    // const Payable_amount = 'payable_amount';
    // const Payment_due_status = 'payment_due_status';
    // const Waiver_amount = 'waiver_amount';
    // const Due_amount = 'due_amount';
    const SITE_ID = 'site_id';
    const Site_group_id = 'site_group_id';
    const DEMAND_SLIP_CREATE_STATUS = 'demand_slip_create_status';
    const Site_student_fee_demand_slip_detail_id = 'site_student_fee_demand_slip_detail_id';
    const STATUS = 'status';
    const Created_by = 'created_by';


    protected $fillable = [
        self::Student_history_id,
        self::Site_student_fee_fine_allocation_id,
        self::Academic_section_id,
        self::Fee_head_type_id,
        self::Academic_fee_head_id,
        self::Academic_fee_sub_head_id,
        self::AMOUNT,
        // self::Payable_amount,
        // self::Payment_due_status,
        // self::Waiver_amount,
        // self::Due_amount,
        self::SITE_ID,
        self::Site_group_id,
        self::DEMAND_SLIP_CREATE_STATUS,
        self::Site_student_fee_demand_slip_detail_id,
        self::STATUS,
        self::Created_by
    ];

    public $ownFields = [
        self::Student_history_id,
        self::Academic_section_id,
        self::Fee_head_type_id,
        self::Academic_fee_head_id,
        self::Academic_fee_sub_head_id,
        self::AMOUNT,
        // self::Payable_amount,
        // self::Payment_due_status,
        // self::Waiver_amount,
        // self::Due_amount,
        self::SITE_ID,
        self::Site_group_id,
        self::DEMAND_SLIP_CREATE_STATUS,
        self::Site_student_fee_demand_slip_detail_id,
        self::STATUS,
        self::Created_by,
    ];


    public function siteStudentFeeFineAllocation()
    {
        return $this->belongsTo(SiteStudentFeeFineAllocation::class);
    }


    public function siteStudentFeeDemandSlipDetails()
    {
        return $this->belongsTo(SiteStudentFeeDemandSlipDetails::class, 'site_student_fee_demand_slip_detail_id', 'id');
    }


    
    public function academicFeeType()
    {
        return $this->belongsTo(AcademicFeeType::class,'fee_head_type_id');
    }

    public function academicFeeHead()
    {
        return $this->belongsTo(AcademicFeeHead::class,'academic_fee_head_id');
    }
    public function academicFeeSubHead()
    {
        return $this->belongsTo(AcademicFeeSubHead::class,'academic_fee_sub_head_id');
    }

}