<?php

namespace App\Models\Site\Fee;

use App\Models\ProjectModel;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class SiteStudentHeadWiseFeePaymentHistory extends ProjectModel
{
    public $timestamps = true;
    protected $table='site_student_head_wise_fee_payment_histories';

    const Student_history_id = 'student_history_id';
    const Site_student_fee_payment_history_id = 'site_student_fee_payment_history_id';
    const Student_fee_generate_id = 'student_fee_generate_id';
    const Amount = 'amount';

    const Payable_amount = 'payable_amount';
    const Pay_amount = 'pay_amount';
    const Waiver_amount = 'waiver_amount';
    const Due_amount = 'due_amount';

    const Sub_total_pay_amount = 'sub_total_pay_amount';
    const Sub_total_due_amount = 'sub_total_due_amount';
    const Sub_total_waiver_amount = 'sub_total_waiver_amount';

    const Payment_collected_status = 'payment_collected_status';
    const Payment_due_status = 'payment_due_status';

    const Collected_by = 'collected_by';
    const Collected_gateway = 'collected_gateway';
    const Site_id = 'site_id';
    const Status = 'status';

    protected $fillable = [
        self::Student_history_id,
        self::Site_student_fee_payment_history_id,
        self::Student_fee_generate_id,
        self::Amount,
        self::Payable_amount,
        self::Pay_amount,
        self::Sub_total_pay_amount,
        self::Payment_collected_status,
        self::Payment_due_status,
        self::Waiver_amount,
        self::Sub_total_waiver_amount,
        self::Due_amount,
        self::Sub_total_due_amount,
        self::Due_amount,
        self::Collected_by,
        self::Collected_gateway,
        self::Site_id,
        self::Status
    ];

    public $ownFields = [
        self::Student_history_id,
        self::Site_student_fee_payment_history_id,
        self::Student_fee_generate_id,
        self::Amount,
        self::Payable_amount,
        self::Pay_amount,
        self::Sub_total_pay_amount,
        self::Payment_collected_status,
        self::Payment_due_status,
        self::Waiver_amount,
        self::Sub_total_waiver_amount,
        self::Due_amount,
        self::Sub_total_due_amount,
        self::Due_amount,
        self::Collected_by,
        self::Collected_gateway,
        self::Site_id,
        self::Status
    ];

    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class,'student_history_id');
    }

    public function collectedBy()
    {
        return $this->belongsTo(User::class,'collected_by');
    }
   
}
