<?php

namespace App\Models\Site;

use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\SoftDeletes;

class GlobalSiteInfo extends ProjectModel
{


    use SoftDeletes; // will be deleted later

    public $timestamps = false;
    protected $dates = ['deleted_at'];

    protected $table = 'site_infos';

    const SITE_MEMBERSHIP_ID = 'site_membership_id';
    const SITE_GROUP_ID = 'site_group_id';
    const Site_Group_Setting_ID = 'site_group_setting_id';
    const Academic_Group_ID = 'academic_group_id';
    const Site_Name = 'site_name';
    const Academic_Class_IDs = 'academic_class_ids';
    const Academic_Section_IDs = 'academic_section_ids';
    const Academic_Class_Group_IDs = 'academic_class_group_ids';
    const Academic_Subject_Condition_IDs = 'academic_subject_condition_ids';
    const SITE_GENDER = 'site_gender';
    const Site_Govt_Code = 'site_govt_code';
    const COUNTRY = 'country_id';
    const DIVISION = 'division_id';
    const DISTRICT = 'district_id';
    const THANA = 'thana_id';
    const Address = 'address';
    const SITE_ALIAS = 'site_alias';
    const SITE_EMAIL = 'site_email';
    const SITE_PHONE = 'site_phone';
    const SITE_LOGO = 'photo';
    const STATUS = 'status';

    protected $fillable = [
        self::SITE_MEMBERSHIP_ID,
        self::SITE_GROUP_ID,
        self::Site_Group_Setting_ID,
        self::Academic_Group_ID,
        self::Site_Name,
        self::Academic_Class_IDs,
        self::Academic_Section_IDs,
        self::Academic_Class_Group_IDs,
        self::Academic_Subject_Condition_IDs,
        self::SITE_GENDER,
        self::Site_Govt_Code,
        self::COUNTRY,
        self::DIVISION,
        self::DISTRICT,
        self::THANA,
        self::Address,
        self::SITE_ALIAS,
        self::SITE_EMAIL,
        self::SITE_PHONE,
        self::SITE_LOGO,
        self::STATUS,
    ];

//    public $translatedAttributes = [
//        self::SITE_NAME,
//        //self::SITE_GENDER,
//        self::SITE_ADDRESS,
//    ];


    public function photo()
    {
        return $this->morphMany(Photo::class, 'imageable');
    }

    public function siteType()
    {
        return $this->belongsTo(SiteType::class);
    }
    public function siteGroup()
    {
        return $this->belongsTo(SiteGroup::class);
    }



    public function siteMembership()
    {
        return $this->hasOne(SiteMembership::class, 'site_id');
    }


    public function menus()
    {
        return $this->belongsToMany(Menu::class,'site_accesses','site_id','menu_id');
    }
}


















