<?php

namespace App\Models\Site;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteShiftClassGroupSectionSetting extends Model
{
    // use SoftDeletes;

    protected $table = 'site_shift_class_group_section_settings';

    public $timestamps = false;
    protected $dates = ['deleted_at'];


    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const ACADEMIC_SECTION_IDS = 'academic_section_ids';
    const SEAT_CAPACITY = 'seat_capacity';
    const SEAT_EXTEND = 'seat_extend';
    const ADMISSION_SEAT_CAPACITY = 'admission_seat_capacity';
    const STATUS = 'status';
    const SITE_ID = 'site_id';


    protected $fillable = [
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SECTION_IDS,
        self::SEAT_CAPACITY,
        self::ADMISSION_SEAT_CAPACITY,
        self::SEAT_EXTEND,
        self::STATUS,
    ];

    public $ownfields = [
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SECTION_IDS,
        self::SEAT_CAPACITY,
        self::ADMISSION_SEAT_CAPACITY,
        self::SEAT_EXTEND,
        self::STATUS,
    ];


    public function academicVersion()
    {
        return $this->belongsTo(AcademicVersion::class);
    }

    public function academicYear()
    {
        return $this->belongsTo(AcademicYear::class);
    }


    public function academicShift()
    {
        return $this->belongsTo(AcademicShift::class);
    }


    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class);
    }

    public function academicDepartment()
    {
        return $this->belongsTo(AcademicDepartment::class);
    }


    public function academicClassGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class);
    }


}
