<?php

namespace App\Models\Site;

use App\Models\Academic\AcademicShift;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteShiftDetails extends Model
{
    protected $table = 'site_shift_details';


    protected $casts=[
        'in_time_allowed_min'=>'integer',
        'in_time_grace'=>'integer',
        'out_time_grace'=>'integer',
        'day_on'=>'integer',
        'site_id'=>'integer',
        'att_allowed'=>'integer',
        'grace_status'=>'integer',
        'status'=>'integer',

    ];


    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_PERIOD_TYPE_ID = 'academic_period_type_id';
    const BELONGS_TO = 'belongs_to';
    const WEEK_DAY = 'week_day';
    const ALLOWED_MIN = 'in_time_allowed_min';
    const IN_TIME = 'in_time';
    const OUT_TIME = 'out_time';
    const IN_TIME_GRACE = 'in_time_grace';
    const OUT_TIME_GRACE = 'out_time_grace';
    const DAY_ON = 'day_on';
    const ATT_ALLOWED = 'att_allowed';
    const SEND_ABSENT_SMS = 'send_absent_sms';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const SITE_ID = 'site_id';
    const GRACE_STATUS = 'grace_status';
    const STATUS = 'status';


    public $timestamps = true;

    protected $fillable = [

        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_PERIOD_TYPE_ID,
        self::BELONGS_TO,
        self::WEEK_DAY,
        self::ALLOWED_MIN,
        self::IN_TIME,
        self::OUT_TIME,
        self::IN_TIME_GRACE,
        self::OUT_TIME_GRACE,
        self::DAY_ON,
        self::ATT_ALLOWED,
        self::SEND_ABSENT_SMS,
        self::ACADEMIC_GROUP_ID,
        self::SITE_ID,
        self::GRACE_STATUS,
        self::STATUS,
    ];


    public  function setInTimeAllowedMin($value){
        return $value ?? 0;
    }


    public function shift()
    {
        return $this->belongsTo(AcademicShift::class, 'academic_shift_id');
    }

}
