<?php

namespace App\Models\Site\Progress;

use App\Models\Academic\AcademicProgress;
use Illuminate\Database\Eloquent\Model;

class SiteProgressSubjectAreasSetting extends Model
{
     protected $table='site_progress_subject_areas_settings';
    protected $appends = array('progress_name');

    const Academic_group_id = 'academic_group_id';
    const Site_id = 'site_id';

    const Academic_year_id = 'academic_year_id';
    const Academic_class_id = 'academic_class_id';
    const Progress_id = 'progress_id';
    const Academic_subject_id = 'academic_subject_id';
    const Subject_learning_area_id = 'subject_learning_area_id';
    const Admit_card_permission_with_due_payment = 'admit_card_permission_with_due_payment';
    const Status = 'status';

     protected $fillable = [
        self::Academic_group_id,
        self::Site_id,

        self::Academic_year_id,
        self::Academic_class_id,
        self::Progress_id,
        self::Academic_subject_id,
        self::Subject_learning_area_id,
        self::Admit_card_permission_with_due_payment,
        self::Status,
     ];


    public function getProgressNameAttribute()
    {
        return  $this->attributes['progress_name']= $this->academicProgress->progress_name;

    }

    public function academicProgress()
    {
        return $this->belongsTo(AcademicProgress::class,'progress_id');
    }

}
