<?php

namespace App\Models\Site\Quiz;

use Illuminate\Database\Eloquent\Model;
use App\Models\Site\Quiz\QuizDeclares;

class QuizDeclareSettings extends Model
{
    const Quiz_declare_id = 'quiz_declare_id';
    const Start_date = 'start_date';
    const Start_time = 'start_time';
    const End_time = 'end_time';
    const Start_date_time = 'start_date_time';
    const End_date_time = 'end_date_time';
    const Duration = 'duration';
    const Question_per_student = 'question_per_student';
    const Result_show_to_student_panel_status = 'result_show_to_student_panel_status';
    const Sent_sms_status = 'sent_sms_status';
    const Is_start = 'is_start';
    const Is_end = 'is_end';
    const Is_cancel = 'is_cancel';
    
    protected $fillable = [
        self::Quiz_declare_id,
        self::Start_date,
        self::Start_time,
        self::End_time,
        self::Start_date_time,
        self::End_date_time,
        self::Duration,
        self::Question_per_student,
        self::Result_show_to_student_panel_status,
        self::Sent_sms_status,
        self::Is_start,
        self::Is_end,
        self::Is_cancel
    ];
    protected $ownFields = [
        self::Quiz_declare_id,
        self::Start_date,
        self::Start_time,
        self::End_time,
        self::Start_date_time,
        self::End_date_time,
        self::Duration,
        self::Question_per_student,
        self::Result_show_to_student_panel_status,
        self::Sent_sms_status,
        self::Is_start,
        self::Is_end,
        self::Is_cancel
    ];
    public function quizDeclare()
    {
        return $this->belongsTo(QuizDeclares::class,'quiz_declare_id');

    }
    // public function quizDeclareStudents()
    // {
    //     return $this->hasMany(QuizDeclareStudents::class,'quiz_declare_id');

    // }
}
