<?php

namespace App\Models\Site\Quiz;

use Illuminate\Database\Eloquent\Model;
use App\Models\SiteGlobalModel;
use App\Models\Site\Quiz\QuizDeclares;
use App\Models\Site\Quiz\Question\StudentQuizAnswerDetails;
use App\Models\Student\StudentHistory;

class QuizDeclareStudents extends Model
{


    const Quiz_declare_id = 'quiz_declare_id';
    const Student_history_id = 'student_history_id';
    const Question_ids = 'student_question_ids';
    const Join_status = 'join_status';
    const End_status = 'end_status';
    const Total_question = 'total_question';
    const Total_answer = 'total_answer';
    const Total_right_answer = 'total_right_answer';
    const Total_wrong_answer = 'total_wrong_answer';
    const Right_ans_percentage = 'right_ans_percentage';
    const Quiz_time = 'quiz_time';
    const Quiz_time_by_second = 'quiz_time_by_second';
    const Mark = 'mark';
    const Rank = 'rank';

    protected $fillable = [
        self::Quiz_declare_id,
        self::Student_history_id,
        self::Question_ids,
        self::Join_status,
        self::End_status,
        self::Total_question,
        self::Total_answer,
        self::Total_right_answer,
        self::Total_wrong_answer,
        self::Right_ans_percentage,
        self::Quiz_time,
        self::Quiz_time_by_second,
        self::Mark,
        self::Rank,
    ];
    protected $ownFields = [
        self::Quiz_declare_id,
        self::Student_history_id,
        self::Question_ids,
        self::Join_status,
        self::End_status,
        self::Total_question,
        self::Total_answer,
        self::Total_right_answer,
        self::Total_wrong_answer,
        self::Right_ans_percentage,
        self::Quiz_time,
        self::Quiz_time_by_second,
        self::Mark,
        self::Rank,
    ];

    public function quizDeclare()
    {
        return $this->belongsTo(QuizDeclares::class,'quiz_declare_id');
    }

 
    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class);

    }

    public function answerDetails()
    {
        return $this->hasMany(StudentQuizAnswerDetails::class,'declare_student_id','id');
    }

    public function correctAnswerDetails()
    {
        return $this->hasMany(StudentQuizAnswerDetails::class,'declare_student_id','id')->where('right_answer_status',1);
    }

    public function incorrectAnswerDetails()
    {
        return $this->hasMany(StudentQuizAnswerDetails::class,'declare_student_id','id')->where('right_answer_status',0);
    }
}
