<?php

namespace App\Models\Site\Quiz;

use Illuminate\Database\Eloquent\Model;
use Dimsav\Translatable\Translatable;
use App\Models\GroupSiteModel;
use App\Models\ProjectModel;


class SiteQuizQuestionDetails extends ProjectModel
{
    use  Translatable;
    public $translationModel = SiteQuizQuestionDetailTranslation::class;
    public $translationForeignKey = 'site_exam_question_detail_id';

    public $timestamps = true;
    protected $table = 'site_exam_question_details';
    protected $dates = ['created_at','updated_at'];



    const SITE_EXAM_QUESTION_ID = 'site_exam_question_id';
    const MARK = 'mark';
    const ANSWER_STATUS = 'answer_status';
    const OPTION = 'option';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const STATUS = 'status';


    protected $fillable = [
        self::SITE_EXAM_QUESTION_ID,
        self::MARK,
        self::ANSWER_STATUS,
        self::OPTION,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,

    ];

    public $translatedAttributes = [
        self::OPTION,
    ];

    public $ownFields = [
        self::SITE_EXAM_QUESTION_ID,
        self::MARK,
        self::ANSWER_STATUS,
        self::OPTION,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
    ];


    public function siteQuizQuestion()
    {
        return $this->belongsTo(SiteQuizQuestion::class, 'site_exam_question_id');
    }

}
