<?php

namespace App\Models\Site\Result\Certification;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteCertificationSetting extends Model
{
    public $timestamps = true;
    protected $table = 'site_certification_settings';


    const Border_image = 'border_image';
    const Watermark_status = 'watermark_status';
    const Watermark_image = 'watermark_image';
    const background_color = 'background_color';

    const Initial_referance_prefix = 'initial_referance_prefix';
    const Initial_referance_number = 'initial_referance_number';
    const Initial_referance_suffix = 'initial_referance_suffix';


    public function newQuery()
    {
        $site_id = (int)session()->get('SITE_ID');


        $builder = $this->newQueryWithoutScopes();
        $tableName = $builder->getModel()->getTable();
        $final = $builder->where($tableName . '.site_id', $site_id);

        return $final;
    }


    const Status = 'status';
    const Site_id = 'site_id';


    protected $fillable = [
        self::Border_image,
        self::Watermark_status,
        self::Watermark_image,
        self::background_color,

        self::Initial_referance_number,
        self::Initial_referance_prefix,
        self::Initial_referance_suffix,

        self::Site_id,
        self::Status,

    ];

    public $ownFields = [

        self::Border_image,
        self::Watermark_status,
        self::Watermark_image,
        self::background_color,

        self::Initial_referance_number,
        self::Initial_referance_prefix,
        self::Initial_referance_suffix,

        self::Site_id,
        self::Status,
    ];
}
