<?php

namespace App\Models\Site\Result;

use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Student\StudentHistory;
use Illuminate\Database\Eloquent\Model;

class SiteStudentPrimaryResultDetailForTabulation extends Model
{
    public $timestamps = true;
    protected $table='site_student_primary_result_details';
//
//    protected $casts = [
//        'result_detail' => 'array'
//    ];


    const SITE_RESULT_PRIMARY_SETTING_ID = 'site_result_primary_setting_id';
    const STUDENT_HISTORY_ID = 'student_history_id';
    const ACADEMIC_RESULT_PRIMARY_TYPE_ID = 'academic_result_primary_type_id';
    const Site_individual_combine_subject_result_store_ids = 'site_individual_combine_subject_result_store_ids';
    const GPA = 'gpa';
    const GRADE = 'grade';
    const FAIL_SUBJECT_COUNT = 'fail_subject_count';
    const RESULT_DETAIL = 'result_detail';
    const TABLE_HEADER = 'table_header';

    const Optional_subject_ids = 'optional_subject_ids';
    const Final_point_without_optional = 'final_point_without_optional';
    const Final_grade_without_optional = 'final_grade_without_optional';
    const Combine_subject_present = 'combine_subject_present';
    const Classtest_is_present = 'classtest_is_present';

    const Sum_of_obtain_raw_total_marks = 'sum_of_obtain_raw_total_marks';
    const Sum_of_obtain_percent_total_marks = 'sum_of_obtain_percent_total_marks';
    const Sum_of_raw_total_marks = 'sum_of_raw_total_marks';
    const Raw_obtain_marks_percentage = 'raw_obtain_marks_percentage';
    const Site_id = 'site_id';
    const Academic_group_id = 'academic_group_id';


    const STATUS = 'status';




    protected $fillable = [
        self::STUDENT_HISTORY_ID,
        self::SITE_RESULT_PRIMARY_SETTING_ID,
        self::ACADEMIC_RESULT_PRIMARY_TYPE_ID,
        self::Site_individual_combine_subject_result_store_ids,

        self::Optional_subject_ids,
        self::Final_point_without_optional,
        self::Final_grade_without_optional,
        self::Combine_subject_present,
        self::Classtest_is_present,

        self::Sum_of_obtain_raw_total_marks,
        self::Sum_of_obtain_percent_total_marks,
        self::Sum_of_raw_total_marks,
        self::Raw_obtain_marks_percentage,

        self::GPA,
        self::GRADE,
        self::FAIL_SUBJECT_COUNT,
        self::RESULT_DETAIL,
        self::TABLE_HEADER,
        self::Site_id,
        self::Academic_group_id,
        self::STATUS,
    ];

    public $ownFields = [
        self::STUDENT_HISTORY_ID,
        self::SITE_RESULT_PRIMARY_SETTING_ID,
        self::ACADEMIC_RESULT_PRIMARY_TYPE_ID,
        self::Site_individual_combine_subject_result_store_ids,

        self::Optional_subject_ids,
        self::Final_point_without_optional,
        self::Final_grade_without_optional,
        self::Combine_subject_present,
        self::Classtest_is_present,

        self::Sum_of_obtain_raw_total_marks,
        self::Sum_of_obtain_percent_total_marks,
        self::Sum_of_raw_total_marks,
        self::Raw_obtain_marks_percentage,

        self::GPA,
        self::GRADE,
        self::FAIL_SUBJECT_COUNT,
        self::RESULT_DETAIL,
        self::TABLE_HEADER,
        self::STATUS,
    ];


    /**
     * @param $values
     * @return mixed
     */
    public function getTableHeaderAttribute($values)
    {
        return $this->attributes['table_header'] = json_decode($values);

    }

    public function getRawObtainMarksPercentageAttribute($values)
    {
        return $this->attributes['raw_obtain_marks_percentage'] = number_format((float)$values, 2, '.', '');

    }


    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class);
    }

    public function globalStudentHistory()
    {
        return $this->belongsTo(GlobalStudentHistory::class,'student_history_id');
    }
    public function academicResultPrimaryType()
    {
        return $this->belongsTo(AcademicResultPrimaryType::class, 'academic_result_primary_type_id');
    }

    public function getSiteIndividualCombineSubjectResultStoreIdsAttribute($value)
    {


        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = SiteIndividualCombineSubjectResultStoreForTabulation::with(['academicSubject'])
        ->whereIn('id', $arr)->orderBy('subject_position')
            // ->select('student_history_id', 'academic_result_primary_type_id', 'exam_dependent_academic_subject_id',
            //     'optional_academic_subject_status', 'subject_base_pass_fail_status', 'obtain_subject_total_marks', 'raw_total_marks',
            //     'subject_marks_percentage', 'obtain_raw_total_marks', 'obtain_percent_total_marks',
            //     'list_for_tabulation', 'subject_grade', 'subject_point', 'subject_position', 'result_show_in_table_bellow_status',
            //     'subject_count','obtain_total_marks_for_show')
            ->get();
        return $array;

    }

    // public function getSiteIndividualCombineSubjectResultStoreIdsAttribute($value)
    // {
    //     $arr = $value ? array_map('intval', explode(',', $value)) : [];
    //     $array = SiteIndividualCombineSubjectResultStore::whereIn('id', $arr)
    //         ->where('status', true)
    //         ->orderBy('subject_position')
    //         ->get();
    //     return $array;

    // }
}

