<?php

namespace App\Models\Site\Role;

use App\Models\ProjectModel;
use App\Models\Site\Permission\SiteRoleAccess;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class SiteRole extends ProjectModel
{
    protected $table='site_roles';
    public $timestamps = true;


    const NAME    = 'name';
    const SITE_ID  = 'site_id';
    const STATUS  = 'status';
    const KEY = 'key';
    const ROLE_DESCRIPTION = 'role_description';


    protected $fillable =[
        self::NAME,
        self::KEY,
        self::SITE_ID,
        self::STATUS,

    ];

    public $ownFields = [
        self::NAME,
        self::ROLE_DESCRIPTION,
        self::STATUS,
    ];

    public function groupAccess()
    {
        return $this->hasOne(SiteRoleAccess::class,'site_role_id');
    }


    public function accesses()
    {
        return $this->hasOne(SiteRoleAccess::class,'site_role_id');
    }


    /**
     * The users that belong to the role.
     */
    public function users()
    {
        return $this->belongsToMany(User::class,'site_role_user', 'role_id', 'user_id');
    }

}
