<?php

namespace App\Models\Site\Room;

use App\Models\Building\Building;
use App\Models\Floor\Floor;
use App\Models\ProjectModel;
use App\Models\Room\Room;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteBaseExamRoomSetting extends ProjectModel
{
    protected $table='site_base_exam_room_settings';


    const Building_id = 'building_id';
    const Floor_id = 'floor_id';
    const Room_id = 'room_id';
    const Column_position = 'column_position';
    const Seat_number = 'seat_number';
    const Seat_position = 'seat_position';
    const Site_id = 'site_id';
    const Status = 'status';



    protected $fillable = [
        self::Building_id,
        self::Floor_id,
        self::Room_id,
        self::Column_position,
        self::Seat_number,
        self::Seat_position,
        self::Site_id,
        self::Status,

    ];

    protected $ownFields = [
        self::Building_id,
        self::Floor_id,
        self::Room_id,
        self::Column_position,
        self::Seat_position,
        self::Seat_number,
        self::Site_id,
        self::Status,
    ];


    public function room()
    {
        return $this->belongsTo(Room::class, 'room_id');
    }

    public function building()
    {
        return $this->belongsTo(Building::class, 'building_id');
    }

    public function floor()
    {
        return $this->belongsTo(Floor::class, 'floor_id');
    }



}
