<?php

namespace App\Models\Site\Routine;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicPeriodType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Edu\WeekdayName;
use App\Models\ProjectModel;

class SiteRoutineDetail extends ProjectModel
{
    public $timestamps = true;
    protected $table = 'site_routine_details';


    const weekday = 'weekday';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_SECTION_ID = 'academic_section_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const ACADEMIC_SESSION_ID = 'academic_session_id';


    protected $fillable = [
        self::weekday,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SESSION_ID,


    ];
    public $ownFields = [
        self::weekday,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SESSION_ID,

    ];


    public function routineAllocations()
    {
        return $this->hasMany(RoutineAllocation::class, 'routine_details_id');
    }


/*    public function classTimingDetail()
    {
        return $this->belongsTo(ClassTimingDetail::class, 'class_timing_details_id');
    }*/


    public function dept()
    {
        return $this->belongsTo(AcademicDepartment::class, 'academic_department_id');
    }

    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class, 'academic_class_id');
    }

    public function academicSection()
    {
        return $this->belongsTo(AcademicSection::class, 'academic_section_id');
    }


    public function classGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, 'academic_class_group_id');
    }

    public function academicYear()
    {
        return $this->belongsTo(AcademicYear::class, 'academic_year_id');
    }
    public function academicShift()
    {
        return $this->belongsTo(AcademicShift::class, 'academic_shift_id');
    }
    public function academicPeriodType()
    {
        return $this->belongsTo(AcademicPeriodType::class, 'academic_period_type_id');
    }

    public function academicSession()
    {
        return $this->belongsTo(AcademicSession::class, 'academic_session_id');
    }


    public function weekDay()
    {
        return $this->belongsTo(WeekdayName::class, 'weekday','weekday_key');
    }

}
