<?php

namespace App\Models\Site\Shift;

use App\Models\Academic\AcademicShift;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\User\GlobalUser;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class GlobalShiftDetail extends Model
{
    protected $table = 'site_shift_details';


    protected $casts = [
        'in_time_allowed_min' => 'integer',
        'in_time_grace' => 'integer',
        'out_time_grace' => 'integer',
        'day_on' => 'integer',
        'site_id' => 'integer',
        'att_allowed' => 'integer',
        'grace_status' => 'integer',
        'status' => 'integer',

    ];


    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_PERIOD_TYPE_ID = 'academic_period_type_id';
    const BELONGS_TO = 'belongs_to';
    const WEEK_DAY = 'week_day';
    const ALLOWED_MIN = 'in_time_allowed_min';
    const IN_TIME = 'in_time';
    const OUT_TIME = 'out_time';
    const IN_TIME_GRACE = 'in_time_grace';
    const OUT_TIME_GRACE = 'out_time_grace';
    const DAY_ON = 'day_on';
    const ATT_ALLOWED = 'att_allowed';
    const SEND_ABSENT_SMS = 'send_absent_sms';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const SITE_ID = 'site_id';
    const GRACE_STATUS = 'grace_status';
    const STATUS = 'status';


    public $timestamps = true;

    public function setInTimeAllowedMin($value)
    {
        return $value ?? 0;
    }


    public function scopeTodayShiftDetail($q, $academic_group_id, $site_id)
    {


        $today_date = Carbon::now()->toDateString();
        $day = date('D', strtotime($today_date));//sun

        //dd($day);
        $get_period_type_duration = \DB::table('site_period_type_durations')
            ->where('start_date', '<=', $today_date)
            ->where('end_date', '>=', $today_date)
            ->where('academic_group_id', $academic_group_id)
            ->where('site_id', $site_id)
            ->first();

        return $q->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id ?? 0)//regular
        ->where('belongs_to', 'student')
            ->where('week_day', $day)//sunday
            ->where('status', true)
            ->where('day_on', true)
            ->where('academic_group_id', $academic_group_id)
            ->where('site_id', $site_id);


    }


    public function shift()
    {
        return $this->belongsTo(AcademicShift::class, 'academic_shift_id');
    }

    public function scopeSendAbsentSmsActive($q)
    {


        $today_date = Carbon::now()->toDateString();
        $day = date('D', strtotime($today_date));//sun

        $current_time = Carbon::now()->toTimeString();
        $minus_time = Carbon::now()->addMinutes(-11)->toTimeString();//11 if absent sms is for 5:10 pm then it return until 5:21

        //dd($current_time,$minus_time);

        return $q->where('belongs_to', 'student')
            ->where('day_on', true)
            ->where('status', true)
            ->where('week_day', $day)//sunday
            ->whereNotNull('send_absent_sms')
            ->whereTime('send_absent_sms', '>=', $minus_time)
            ->whereTime('send_absent_sms', '<=', $current_time);

    }

}
