<?php

namespace App\Models\Site;

use App\Models\ProjectModel;
use App\Models\Academic\AcademicClass;
use Illuminate\Database\Eloquent\Model;

class SiteClassSimilarity extends ProjectModel
{
    const ACADEMIC_CLASS_ID  = 'academic_class_id';
    const SIMILAR_CLASS_ID  = 'similar_class_id';
    const STATUS  = 'status';
    public $timestamps = true;

    protected $fillable =[

        self::ACADEMIC_CLASS_ID,
        self::SIMILAR_CLASS_ID,
        self::STATUS,

    ];


    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class);
    }

    public function classSimilarity()
    {
        return $this->belongsTo(AcademicClass::class,'similar_class_id');
    }
}
