<?php

namespace App\Models\Site;

use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;

class SiteInfoSettingForSite extends ProjectModel
{
    public $timestamps = false;
    protected $dates = ['deleted_at'];
    protected $table='site_info_settings';


    const Site_Group_Setting_ID = 'site_group_setting_id';
    const Academic_Group_ID = 'academic_group_id';

    const SITE_ID = 'site_id';
    const ACADEMIC_VERSION_IDs = 'academic_version_ids';
    const ACADEMIC_YEAR_IDs = 'academic_year_ids';
    const ACADEMIC_SESSION_IDs = 'academic_session_ids';
    const ACADEMIC_SESSION_TYPE_IDs = 'academic_session_type_ids';
    const ACADEMIC_STUDENT_CATEGORY_IDs = 'academic_student_category_ids';
    const ACADEMIC_STUDENT_TYPE_IDs = 'academic_student_type_ids';

    const Academic_Class_IDs = 'academic_class_ids';
    const Academic_Department_IDs = 'academic_department_ids';
    const Academic_Subject_IDs = 'academic_subject_ids';
    const Academic_Section_IDs = 'academic_section_ids';
    const Academic_Class_Group_IDs = 'academic_class_group_ids';
    const Academic_Subject_Condition_IDs = 'academic_subject_condition_ids';
    const Shift_IDs = 'shift_ids';
    const Gender_IDs = 'gender_ids';
    const SITE_GOVT_CODE = 'site_govt_code';
    const Religion_IDs = 'religion_ids';
    const Academic_Residence_IDs = 'academic_residence_ids';
    const STATUS = 'status';


    protected $fillable = [
        self::Site_Group_Setting_ID,
        self::ACADEMIC_VERSION_IDs,
        self::ACADEMIC_YEAR_IDs,
        self::ACADEMIC_SESSION_IDs,
        self::ACADEMIC_SESSION_TYPE_IDs,
        self::ACADEMIC_STUDENT_CATEGORY_IDs,
        self::ACADEMIC_STUDENT_TYPE_IDs,
        self::SITE_ID,
        self::Site_Group_Setting_ID,
        self::Academic_Group_ID,
        self::Academic_Class_IDs,
        self::Academic_Department_IDs,
        self::Academic_Subject_IDs,
        self::Shift_IDs,
        self::Gender_IDs,
        self::Religion_IDs,
        self::Academic_Section_IDs,
        self::Academic_Class_Group_IDs,
        self::Academic_Subject_Condition_IDs,
        self::Academic_Residence_IDs,
        self::SITE_GOVT_CODE,
        self::STATUS,
    ];

    public $ownfields = [
        self::Site_Group_Setting_ID,
        self::ACADEMIC_VERSION_IDs,
        self::ACADEMIC_YEAR_IDs,
        self::ACADEMIC_SESSION_IDs,
        self::ACADEMIC_SESSION_TYPE_IDs,
        self::ACADEMIC_STUDENT_CATEGORY_IDs,
        self::ACADEMIC_STUDENT_TYPE_IDs,
        self::SITE_ID,
        self::Site_Group_Setting_ID,
        self::Academic_Group_ID,
        self::Academic_Class_IDs,
        self::Academic_Department_IDs,
        self::Academic_Subject_IDs,
        self::Shift_IDs,
        self::Gender_IDs,
        self::Religion_IDs,
        self::Academic_Section_IDs,
        self::Academic_Class_Group_IDs,
        self::Academic_Subject_Condition_IDs,
        self::Academic_Residence_IDs,
        self::SITE_GOVT_CODE,
        self::STATUS,
    ];
}
