<?php

namespace App\Models\Site\StudentAdmission;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Examinations\Examination;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteStudentAdmissionDeclare extends Model
{
    protected $table='site_student_admission_declares';


    const Start_date = 'duration_from_date';
    const End_date = 'duration_to_date';
    const Extended_date = 'extended_date';
    const Remark = 'remark';
    const Send_sms = 'send_sms';

    const Academic_group_id = 'academic_group_id';
    const Academic_year_ids = 'academic_year_ids';
    const Academic_version_ids = 'academic_version_ids';
    const Academic_shift_ids = 'academic_shift_ids';
    const Academic_department_ids = 'academic_department_ids';
    const Academic_class_ids = 'academic_class_ids';
    const Academic_session_ids = 'academic_session_ids';
    const Student_type_ids = 'student_type_ids';
    const Old_student_information_add = 'old_student_information_add';


    const Subject_condition_status = 'subject_condition_status';
    const Guardian_information_add = 'guardian_information_add';
    const Address_information_add = 'address_information_add';
    const Communication_information_add = 'communication_information_add';
    const Local_guardian_detail_information_add = 'local_guardian_detail_information_add';
    const Student_registration_number_box_show = 'student_registration_number_box_show';

    const Check_with_roll_number = 'check_with_roll_number';
    const Check_with_online_transaction_id = 'check_with_online_transaction_id';
    const Check_with_second_online_transaction_id = 'check_with_second_online_transaction_id';
    const Terms_condition_show_top = 'terms_condition_show_top';
    const Terms_condition_show_bellow = 'terms_condition_show_bellow';
    const Check_with_board_university = 'check_with_board_university';
    const Education_qualification_ids = 'education_qualification_ids';
    const Admission_form_language = 'admission_form_language';
    const Academic_payment_type_id = 'academic_payment_type_id';
    const Payment_company_ids = 'payment_company_ids';
    const Term_condition = 'term_condition';

    const Group_wise_roll_create_status = 'group_wise_roll_create_status';
    const Auto_roll_create_status = 'auto_roll_create_status';
    const Auto_roll_digit = 'auto_roll_digit';
    const Bank_recipt_downlaod_status = 'bank_recipt_downlaod_status';

    const Exam_passing_year_show = 'exam_passing_year_show';
    const Passing_year_examination_id = 'passing_year_examination_id';

    const Site_id = 'site_id';
    const Status = 'status';

    const Form_number_entry_box_show = 'form_number_entry_box_show';
    const Form_number_check = 'form_number_check';
    const Form_show_to_website = 'form_show_to_website';
    const Site_can_not_approve_student = 'site_can_not_approve_student';
    const Academic_admission_style_id = 'academic_admission_style_id';
    const Site_group_admission_declare_id = 'site_group_admission_declare_id';
    const Site_group_id = 'site_group_id';
    const Conflig_compulsory_subject_ids = 'conflig_compulsory_subject_ids';
    const Parents_contact_number_required = 'parents_contact_number_required';
    const Birth_certificate_no_required = 'birth_certificate_no_required';
    const Office_will_fillup_text_show_status = 'office_will_fillup_text_show_status';
    const Unique_code_show_status = 'unique_code_show_status';

    protected $fillable = [
        self::Start_date,

        self::End_date,
        self::Extended_date,
        self::Remark,
        self::Send_sms,
        self::Academic_group_id,
        self::Academic_year_ids,
        self::Academic_version_ids,
        self::Academic_shift_ids,
        self::Academic_department_ids,
        self::Academic_class_ids,
        self::Academic_session_ids,
        self::Student_type_ids,
        self::Old_student_information_add,

        self::Subject_condition_status,
        self::Guardian_information_add,
        self::Address_information_add,
        self::Communication_information_add,
        self::Student_registration_number_box_show,

        self::Group_wise_roll_create_status,
        self::Auto_roll_create_status,
        self::Auto_roll_digit,
        self::Bank_recipt_downlaod_status,
        self::Exam_passing_year_show,
        self::Passing_year_examination_id,

        self::Site_id,
        self::Status,

        self::Form_number_entry_box_show,
        self::Form_number_check,
        self::Form_show_to_website,
        self::Site_can_not_approve_student,
        self::Academic_admission_style_id,
        self::Site_group_admission_declare_id,
        self::Site_group_id,
        self::Conflig_compulsory_subject_ids,
        self::Parents_contact_number_required,
        self::Birth_certificate_no_required,
        self::Office_will_fillup_text_show_status,
        self::Unique_code_show_status,
    ];



    protected $ownFields = [
        self::Start_date,
        self::End_date,
        self::Extended_date,
        self::Remark,
        self::Send_sms,
        self::Academic_group_id,
        self::Academic_year_ids,
        self::Academic_version_ids,
        self::Academic_shift_ids,
        self::Academic_department_ids,
        self::Academic_class_ids,
        self::Academic_session_ids,
        self::Student_type_ids,
        self::Old_student_information_add,

        self::Guardian_information_add,
        self::Address_information_add,
        self::Communication_information_add,
        self::Student_registration_number_box_show,

        self::Group_wise_roll_create_status,
        self::Auto_roll_create_status,
        self::Auto_roll_digit,
        self::Bank_recipt_downlaod_status,
        self::Exam_passing_year_show,
        self::Passing_year_examination_id,

        self::Site_id,
        self::Status,
        self::Form_number_entry_box_show,
        self::Form_number_check,
        self::Form_show_to_website,
        self::Site_can_not_approve_student,
        self::Academic_admission_style_id,
        self::Site_group_admission_declare_id,
        self::Site_group_id,
     
    ];



    public function photo()
    {
        return $this->morphOne('App\Models\Site\Student\Student', 'imageable');

    }


    public function getSendSmsAttribute($value) {

        return $this->attributes['send_sms'] = $value==1?true:false;
    }

    public function academicGroup()
    {
        return $this->belongsTo(AcademicGroup::class);
    }


    public function getAcademicShiftIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicShift::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicVersionIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicVersion::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicYearIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicYear::whereIn('id', $arr)->orderBy('serial_no','DESC')->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicDepartmentIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicDepartment::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicClassIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicClass::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }

    public function getAcademicSessionIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicSession::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }

    public function getStudentTypeIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicStudentType::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }

    public function getConfligCompulsorySubjectIdsAttribute($value) {
        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }

    public function globalSiteStudentAdmissionDeclareOnlineApi()
    {
        return $this->hasMany(GlobalSiteStudentAdmissionDeclareOnlineApi::class, 'site_student_admission_declare_id');
    }


    public function examination()
    {
        return $this->belongsTo(Examination::class, 'passing_year_examination_id');
    }



}
