<?php

namespace App\Models\Site\StudentRegistration;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteBaseStudentRegistrationDeclare extends Model
{
    protected $table='site_base_student_registration_declares';


    const Start_date = 'start_date';
    const End_date = 'end_date';
    const Extended_date = 'extended_date';
    const Remark = 'remark';

    const Academic_group_id = 'academic_group_id';
    const Academic_year_ids = 'academic_year_ids';
    const Academic_version_ids = 'academic_version_ids';
    const Academic_shift_ids = 'academic_shift_ids';
    const Academic_department_ids = 'academic_department_ids';
    const Academic_class_ids = 'academic_class_ids';
    const Academic_section_ids = 'academic_section_ids';
    const Academic_session_ids = 'academic_session_ids';

    const Site_id = 'site_id';
    const Status = 'status';




    protected $fillable = [
        self::Start_date,
        self::End_date,
        self::Extended_date,
        self::Remark,
        self::Academic_group_id,
        self::Academic_year_ids,
        self::Academic_version_ids,
        self::Academic_shift_ids,
        self::Academic_department_ids,
        self::Academic_class_ids,
        self::Academic_session_ids,
        self::Site_id,
        self::Status,
    ];



    protected $ownFields = [
        self::Start_date,
        self::End_date,
        self::Extended_date,
        self::Remark,
        self::Academic_group_id,
        self::Academic_year_ids,
        self::Academic_version_ids,
        self::Academic_shift_ids,
        self::Academic_department_ids,
        self::Academic_class_ids,
        self::Academic_session_ids,
        self::Site_id,
        self::Status,
    ];


    public function academicGroup()
    {
        return $this->belongsTo(AcademicGroup::class);
    }

    public function getAcademicShiftIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicShift::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicVersionIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicVersion::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicYearIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicYear::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicDepartmentIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicDepartment::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicClassIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicClass::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicSectionIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicSection::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }

    public function getAcademicSessionIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicSession::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }

}
