<?php

namespace App\Models\Site\StudentRegistration;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteBaseStudentRegistrationDeclare extends SiteGlobalModel
{
    protected $table='site_base_student_registration_declares';


    const Start_date = 'start_date';
    const End_date = 'end_date';
    const Extended_date = 'extended_date';
    const Remark = 'remark';
    const Send_sms = 'send_sms';

    const Academic_group_id = 'academic_group_id';
    const Academic_year_ids = 'academic_year_ids';
    const Academic_version_ids = 'academic_version_ids';
    const Academic_shift_ids = 'academic_shift_ids';
    const Academic_department_ids = 'academic_department_ids';
    const Academic_class_ids = 'academic_class_ids';
    const Academic_section_ids = 'academic_section_ids';
    const Academic_session_ids = 'academic_session_ids';
    const Old_student_information_add = 'old_student_information_add';


    const Guardian_information_add = 'guardian_information_add';
    const Address_information_add = 'address_information_add';
    const Communication_information_add = 'communication_information_add';
    const Previous_institute_information_add = 'previous_institute_information_add';
    const Local_guardian_detail_information_add = 'local_guardian_detail_information_add';
    const Student_registration_number_box_show = 'student_registration_number_box_show';

    const Terms_condition = 'terms_condition';
    const Terms_condition_show_bellow = 'terms_condition_show_bellow';
    const Terms_condition_show_top = 'terms_condition_show_top';
    const Last_name_show_status = 'last_name_show_status';


    const Site_id = 'site_id';
    const Status = 'status';




    protected $fillable = [
        self::Start_date,
        self::End_date,
        self::Extended_date,
        self::Remark,
        self::Send_sms,
        self::Academic_group_id,
        self::Academic_year_ids,
        self::Academic_version_ids,
        self::Academic_shift_ids,
        self::Academic_department_ids,
        self::Academic_class_ids,
        self::Academic_section_ids,
        self::Academic_session_ids,
        self::Old_student_information_add,

        self::Guardian_information_add,
        self::Address_information_add,
        self::Communication_information_add,
        self::Previous_institute_information_add,
        self::Local_guardian_detail_information_add,
        self::Student_registration_number_box_show,

        self::Terms_condition,
        self::Terms_condition_show_bellow,
        self::Terms_condition_show_top,
        self::Last_name_show_status,

        self::Site_id,
        self::Status,
    ];



    protected $ownFields = [
        self::Start_date,
        self::End_date,
        self::Extended_date,
        self::Remark,
        self::Send_sms,
        self::Academic_group_id,
        self::Academic_year_ids,
        self::Academic_version_ids,
        self::Academic_shift_ids,
        self::Academic_department_ids,
        self::Academic_class_ids,
        self::Academic_section_ids,
        self::Academic_session_ids,
        self::Old_student_information_add,

        self::Guardian_information_add,
        self::Address_information_add,
        self::Communication_information_add,
        self::Previous_institute_information_add,
        self::Local_guardian_detail_information_add,
        self::Student_registration_number_box_show,

        self::Terms_condition,
        self::Terms_condition_show_bellow,
        self::Terms_condition_show_top,
        self::Last_name_show_status,


        self::Site_id,
        self::Status,
    ];



    public function photo()
    {
        return $this->morphOne('App\Models\Site\Student\Student', 'imageable');

    }


    public function getSendSmsAttribute($value) {

        return $this->attributes['send_sms'] = $value==1?true:false;
    }


    public function getAcademicShiftIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicShift::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicVersionIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicVersion::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicYearIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicYear::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicDepartmentIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicDepartment::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicClassIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicClass::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicSectionIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicSection::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }

    public function getAcademicSessionIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicSession::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }

}
