<?php

namespace App\Models\Site\TC;

use App\Models\Image\Photo;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteTcSetting extends SiteGlobalModel
{
    public $timestamps = false;
    protected $table='site_student_tc_settings';

    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';

    const Logo_position = 'logo_position';
    const Border_image_status = 'border_image_status';
    const Border_image = 'border_image';
    const Watermark_status = 'watermark_status';
    const Watermark_image = 'watermark_image';
    const Address_present_status = 'address_present_status';
    const Eiin_show_status = 'eiin_show_status';
    const College_code_show_status = 'college_code_show_status';
    const NU_code_show_status = 'nu_code_show_status';
    const Referance_prefix = 'referance_prefix';
    const Referance_number = 'referance_number';
    const Referance_suffix = 'referance_suffix';

    const Session_show_status = 'session_show_status';
    const Parents_title_status = 'parents_title_status';
    const Written_by_show_status = 'written_by_show_status';
    const Printed_date_show = 'printed_date_show';
    const TC_background_color = 'tc_background_color';

    const Des_part_1 = 'des_part_1';
    const Des_part_2 = 'des_part_2';
    const Des_part_3 = 'des_part_3';
    const Des_part_4 = 'des_part_4';
    const Des_part_5 = 'des_part_5';
    const Des_part_6 = 'des_part_6';
    const Des_part_7 = 'des_part_7';
    const Des_part_8 = 'des_part_8';
    const Des_part_9 = 'des_part_9';

    const Academic_name_font = 'academic_name_font';
    const Academic_address_font = 'academic_address_font';
    const Title_font = 'title_font';
    const Ref_no_font = 'ref_no_font';
    const Description_font = 'description_font';
    const Print_data_font = 'print_data_font';
    const Author_font = 'author_font';

    const Status = 'status';


    protected $fillable = [
        self::ACADEMIC_GROUP_ID,
        self::Logo_position,
        self::Border_image_status,
        self::Border_image,
        self::Watermark_status,
        self::Watermark_image,
        self::Address_present_status,
        self::Eiin_show_status,
        self::College_code_show_status,
        self::NU_code_show_status,
        self::Referance_prefix,
        self::Referance_suffix,
        self::Referance_number,

        self::Session_show_status,
        self::Parents_title_status,
        self::Written_by_show_status,
        self::Printed_date_show,
        self::TC_background_color,

        self::Des_part_1,
        self::Des_part_2,
        self::Des_part_3,
        self::Des_part_4,
        self::Des_part_5,
        self::Des_part_6,
        self::Des_part_7,
        self::Des_part_8,
        self::Des_part_9,

        self::Academic_name_font,
        self::Academic_address_font,
        self::Title_font,
        self::Ref_no_font,
        self::Description_font,
        self::Print_data_font,
        self::Author_font,
        self::Status,
    ];

    public $ownFields = [
        self::ACADEMIC_GROUP_ID,
        self::Logo_position,
        self::Border_image_status,
        self::Border_image,
        self::Watermark_status,
        self::Watermark_image,
        self::Address_present_status,
        self::Eiin_show_status,
        self::College_code_show_status,
        self::NU_code_show_status,
        self::Referance_prefix,
        self::Referance_suffix,
        self::Referance_number,

        self::Session_show_status,
        self::Parents_title_status,
        self::Printed_date_show,
        self::Written_by_show_status,
        self::TC_background_color,

        self::Des_part_1,
        self::Des_part_2,
        self::Des_part_3,
        self::Des_part_4,
        self::Des_part_5,
        self::Des_part_6,
        self::Des_part_7,
        self::Des_part_8,
        self::Des_part_9,

        self::Academic_name_font,
        self::Academic_address_font,
        self::Title_font,
        self::Ref_no_font,
        self::Description_font,
        self::Print_data_font,
        self::Author_font,

        self::SITE_ID,
        self::Status,

    ];

    public function photos()
    {
        return $this->hasOne(Photo::class, 'imageable_id')->orderBy('id', 'DESC');
    }


}