<?php

namespace App\Models\Site\Web\AboutUs;

use App\Models\Image\Photo;
use App\Models\ProjectModel;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class AboutUs extends ProjectModel
{

    use  Translatable, SoftDeletes;

    public $translationModel = AboutUsTranslation::class;
    public $translationForeignKey = 'about_us_id';

    public $timestamps = true;
    protected $table = 'website_about_us';
    protected $dates = ['created_at','updated_at'];

    protected $casts = ['status' => 'integer'];

    const TYPE = 'type';
    const TITLE = 'title';
    const DESCRIPTION = 'description';
    const CREATED_BY = 'created_by';
    const STATUS = 'status';




    protected $fillable = [
        self::TYPE,
        self::TITLE,
        self::DESCRIPTION,
        self::CREATED_BY,
        self::STATUS
    ];

    public $translatedAttributes = [
        self::TITLE,
        self::DESCRIPTION
    ];


    public $ownFields = [
        self::TYPE,
        self::TITLE,
        self::DESCRIPTION,
        self::CREATED_BY,
        self::STATUS
    ];


    public function latestPhoto()
    {
        return $this->hasOne(Photo::class, 'imageable_id')
            ->where('imageable_type','App\Models\Site\Web\AboutUs\AboutUs')
            ->orderBy('id', 'DESC');
    }




    public function files()
    {
        return $this->morphMany(Photo::class, 'imageable');

    }

}
