<?php

namespace App\Models\Site\Web\Event;

use App\Http\Controllers\ProjectController;
use App\Models\Image\Photo;
use App\Models\ProjectModel;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class Event extends ProjectModel
{
    use  Translatable;
    public $translationModel = EventTranslation::class;
    public $translationForeignKey = 'event_id';

    public $timestamps = true;
    protected $table = 'website_events';
    protected $dates = ['created_at','updated_at'];

    protected $casts = ['status' => 'integer'];

    const TITLE = 'event_title';
    const DESCRIPTION = 'event_description';
    const TYPE = 'type';
    const CREATED_BY = 'created_by';
    const STATUS = 'status';
    const SITE_ID = 'site_id';




    protected $fillable = [
        self::TITLE,
        self::DESCRIPTION,
        self::TYPE,
        self::CREATED_BY,
        self::STATUS,
        self::SITE_ID,
    ];

    public $translatedAttributes = [
        self::TITLE,
        self::DESCRIPTION
    ];


    public $ownFields = [
        self::TITLE,
        self::DESCRIPTION,
        self::TYPE,
        self::CREATED_BY,
        self::STATUS,
        self::SITE_ID,

    ];




    public function files()
    {
        return $this->morphMany(Photo::class, 'imageable');

    }

   

}
