<?php

namespace App\Models\Site\Web\Message;

use App\Models\Image\Photo;
use App\Models\ProjectModel;
//use App\Models\User\User;
use App\User;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class Message extends ProjectModel
{

    use  Translatable;
    public $translationModel = MessageTranslation::class;
    public $translationForeignKey = 'website_message_id';

    public $timestamps = true;
    protected $table = 'website_messages';
    protected $dates = ['created_at','updated_at'];

    protected $casts = ['status' => 'integer'];

    const MESSAGE_FROM = 'message_from';
    const USER_ID = 'user_id';
    const SITE_ID = 'site_id';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const MESSAGE = 'message';
    const NAME = 'name';
    const SERIAL = 'serial';
    const DESIGNATION = 'designation';
    const STATUS = 'status';




    protected $fillable = [
        self::MESSAGE_FROM,
        self::USER_ID,
        self::SITE_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::MESSAGE,
        self::NAME,
        self::DESIGNATION,
        self::SERIAL,
        self::STATUS
    ];

    public $translatedAttributes = [
        self::MESSAGE,
        self::NAME,
    ];


    public $ownFields = [
        self::MESSAGE_FROM,
        self::USER_ID,
        self::SITE_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::MESSAGE,
        self::NAME,
        self::SERIAL,
        self::DESIGNATION,
        self::STATUS
    ];




    public function files()
    {
        return $this->morphMany(Photo::class, 'imageable');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');

    }
}
