<?php

namespace App\Models\SiteGroup\Exam;

use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\SiteGroupGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteGroupStudentExamRoll extends SiteGroupGlobalModel
{
    public $timestamps = true;
    protected $table='site_group_student_exam_rolls';

    const Site_group_id='site_group_id';
    const Academic_group_id='academic_group_id';
    const Site_id='site_id';
    const Examination_id='examination_id';
    const Student_history_id='student_history_id';
    const Roll='roll';

    protected $fillable =[
        self::Site_group_id,
        self::Site_id,
        self::Examination_id,
        self::Student_history_id,
        self::Roll,
    ];

    public function studentHistory()
    {
        return $this->belongsTo(GlobalStudentHistory::class, 'student_history_id');
    }
    public function siteInfo()
    {
        return $this->belongsTo(GlobalSiteInfo::class, 'site_id');
    }

}
